/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "audioplayer.h"
#include "configuration.h"

#include <QTextStream>

static QTextStream cout(stdout, QIODevice::WriteOnly);

AudioPlayer::AudioPlayer()
    : QObject(),
      m_mediaObject(0)
{
    updateConfiguration();
}


AudioPlayer::~AudioPlayer()
{
    if (m_mediaObject)
        delete m_mediaObject;
}


void AudioPlayer::play()
{
    if (m_soundEnabled && !m_mediaObject)
    {
        m_mediaObject = Phonon::createPlayer(Phonon::AccessibilityCategory, Phonon::MediaSource(m_soundFile));
        connect(m_mediaObject, SIGNAL(finished()), this, SLOT(slotFinished()));

        m_mediaObject->play();
    }
}


void AudioPlayer::updateConfiguration()
{
    m_soundEnabled = Configuration::config()->soundEnabled();

    if (m_soundEnabled)
        m_soundFile = Configuration::config()->soundFile();
}


void AudioPlayer::slotFinished()
{
    if (m_mediaObject)
        delete m_mediaObject;
}
