/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef MAP_H
#define MAP_H

//KDE
#include <kassistantdialog.h>

//Ui
#include "ui_map_assistant_intro.h"
#include "ui_map_assistant_step1.h"
#include "ui_map_assistant_step2.h"
#include "ui_map_assistant_summary.h"

//KGRUBEditor
#include "core/data.h"

/**
 * @short Map Assistant.
 *
 * Creates / edits GRUB maps step-to-step.
 */
class MapAssistant : public KAssistantDialog
{
Q_OBJECT
public:
	/**
	* Constructor. Populates the KAssistantDialog, shows the map and
	* connects the signals to their slots.
	*
	* @param map The GRUB Map to edit.
	* @param parent QWidget parent. Self explanatory.
	*/
	MapAssistant( GRUB::ComplexCommand::Map *map, QWidget *parent = 0 );
private:
	/**
	* Checks if a device already exists in the combo box of devices.
	* Makes sure that no duplicates are entered in this comboBox.
	*
	* @param device The device to check.
	*
	* @return whether the device already exists in the combobox or not.
	*/
	bool alreadyExists( const QString device );
private slots:
	/**
	* Before accessing the last page, it collects all data
	* that where entered by the user and creates a summary.
	*/
	void nextClicked();
	/**
	* If the Finish button is pressed, finalises all changes
	* done to the map.
	*/
	void finishClicked();
private:
	Ui::map_assistant_intro ui_intro;
	Ui::map_assistant_step1 ui_step1;
	Ui::map_assistant_step2 ui_step2;
	Ui::map_assistant_summary ui_summary;

	KPageWidgetItem *summaryPage;

	GRUB::ComplexCommand::Map *m_map;
};

#endif
