/*
 *  Interface/wrapper for GStreamer GstAutoplug
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "autoplug.h"
#include "caps.h"
#include "element.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_AUTOPLUG(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* Autoplug::wrapperFactory(void *real) {
	return new Autoplug(real);
}

Autoplug::Autoplug(void *real) :
	Object(real) {
}

Autoplug::~Autoplug() {
}

Autoplug* Autoplug::wrap(void *real) {
	return (Autoplug*) Object::wrap(real);
}

Element* Autoplug::toCaps(Caps *srccaps, 
			  Caps *sinkcaps1, 
			  Caps *sinkcaps2,
			  Caps *sinkcaps3,
			  Caps *sinkcaps4,
			  Caps *sinkcaps5) {
#define ox(x) ((x) ? (GST_CAPS((x)->realObject())) : 0)
	if (!sinkcaps2) 
		return Element::wrap(gst_autoplug_to_caps(r(),
						  GST_CAPS(srccaps->realObject()),
							  ox(sinkcaps1),
							  0));
	else if (!sinkcaps3) 
		return Element::wrap(gst_autoplug_to_caps(r(),
						  GST_CAPS(srccaps->realObject()),
							  ox(sinkcaps1),
							  ox(sinkcaps2),
							  0));
	else if (!sinkcaps4) 
		return Element::wrap(gst_autoplug_to_caps(r(),
						  GST_CAPS(srccaps->realObject()),
							  ox(sinkcaps1),
							  ox(sinkcaps2),
							  ox(sinkcaps3),
							  0));
	else if (!sinkcaps5) 
		return Element::wrap(gst_autoplug_to_caps(r(),
						  GST_CAPS(srccaps->realObject()),
							  ox(sinkcaps1),
							  ox(sinkcaps2),
							  ox(sinkcaps3),
							  ox(sinkcaps4),
							  0));
	else  
		return Element::wrap(gst_autoplug_to_caps(r(),
			                          GST_CAPS(srccaps->realObject()),
							  ox(sinkcaps1),
							  ox(sinkcaps2),
							  ox(sinkcaps3),
							  ox(sinkcaps4),
							  ox(sinkcaps5),
							  0));
#undef ox
}

Element* Autoplug::toRenderers(Caps *srccaps, 
			       Element *target1,
			       Element *target2,
			       Element *target3,
			       Element *target4,
			       Element *target5) {
#define ox(x) ((x) ? (GST_ELEMENT((x)->realObject())) : 0)
	if (!target2) 
		return Element::wrap(gst_autoplug_to_renderers(r(),
			       GST_CAPS(srccaps->realObject()),
			       ox(target1),
			       0));
	else if (!target3) 
		return Element::wrap(gst_autoplug_to_renderers(r(),
				GST_CAPS(srccaps->realObject()),
				ox(target1),
				ox(target2),
				0));
	else if (!target4) 
		return Element::wrap(gst_autoplug_to_renderers(r(),
				GST_CAPS(srccaps->realObject()),
				ox(target1),
				ox(target2),
				ox(target3),
				0));
	else if (!target5) 
		return Element::wrap(gst_autoplug_to_renderers(r(),
				GST_CAPS(srccaps->realObject()),
				ox(target1),
				ox(target2),
				ox(target3),
				ox(target4),
				0));
	else  
		return Element::wrap(gst_autoplug_to_renderers(r(),
				GST_CAPS(srccaps->realObject()),
				ox(target1),
				ox(target2),
				ox(target3),
				ox(target4),
				ox(target5),
				0));
#undef ox
}

#include "autoplug.moc"

