/*
 *  Interface/wrapper for GStreamer GstDParamManager
 *  Copyright (C) 2003 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "dparammanager.h"
#include "dparam.h"
#include "element.h"
#include "helper.h"

extern "C" {
#include <gst/gst.h>
#include <gst/control/control.h>
}

using namespace KDE::GST;
using namespace KDE::GST::DP;

#define r() GST_DPMAN(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* DParamManager::wrapperFactory(void *real) {
	return new DParamManager(real);
}

DParamManager::DParamManager(void *real) :
	Object(real) {
}
DParamManager::~DParamManager() {
}

DParamManager* DParamManager::wrap(void *real) {
	return (DParamManager*) Object::wrap(real);
}

DParamManager *DParamManager::getManager(Element *element) {
	return wrap(gst_dpman_get_manager(GST_ELEMENT(element->realObject())));
}

DParamManager::DParamManager(const QString &name, Element *element) :
	Object(0) {
	m_real = gst_dpman_new((gchar*)name.latin1(), GST_ELEMENT(element->realObject()));
	registerReal();
}

bool DParamManager::attachDParam(const QString &dparamName, DParam *dparam) {
	return CONVERT_GBOOL(gst_dpman_attach_dparam(r(),
						     (gchar*)dparamName.latin1(),
						     GST_DPARAM(dparam->realObject())));
}

void DParamManager::detachDPparam(const QString dparamName) {
	gst_dpman_detach_dparam(r(), (gchar*)dparamName.latin1());
}
		
DParam *DParamManager::getDParam(const QString &name) {
	return DParam::wrap(gst_dpman_get_dparam(r(),
						 (gchar*)name.latin1()));
}

void DParamManager::setRate(int rate) {
	gst_dpman_set_rate(r(), rate);
}

void DParamManager::setParent(Element *parent) {
	gst_dpman_set_parent(r(), GST_ELEMENT(parent->realObject()));
}

void DParamManager::setMode(const QString &mode) {
	gst_dpman_set_mode(r(), (gchar*)mode.latin1());
}


#include "dparammanager.moc"

