/*
 *  Interface/wrapper for GStreamer GstElementFactory
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "elementfactory.h"
#include "padtemplate.h"
#include "element.h"
#include "caps.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_ELEMENT_FACTORY(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* ElementFactory::wrapperFactory(void *real) {
	return new ElementFactory(real);
}

ElementFactory::ElementFactory(void *real) :
	Wrapper(real) {
}
ElementFactory::~ElementFactory() {
}

ElementFactory* ElementFactory::wrap(void *real) {
	return (ElementFactory*) Wrapper::wrap(real);
}

ElementFactory* ElementFactory::find(const QString &name) {
	return wrap(gst_element_factory_find(name.latin1()));
}

void ElementFactory::addPadTemplate(PadTemplate *templ) {
	gst_element_factory_add_pad_template(r(),
					     GST_PAD_TEMPLATE(templ->realObject()));
}

bool ElementFactory::canSrcCaps(Caps *caps) {
	return gst_element_factory_can_src_caps(r(), GST_CAPS(caps->realObject()));
}

bool ElementFactory::canSinkCaps(Caps *caps) {
	return gst_element_factory_can_sink_caps(r(), GST_CAPS(caps->realObject()));
}

Element *ElementFactory::create(const QString &name) {
	return Element::wrap(gst_element_factory_create(r(), name.latin1()));
}

Element* ElementFactory::make(const QString &factoryname, const QString &name) {
	return Element::wrap(gst_element_factory_make(factoryname.latin1(), name.latin1()));
}

void ElementFactory::setRank(unsigned short rank) {
	gst_element_factory_set_rank(r(), rank);
}

#include "elementfactory.moc"

