/*
 *  Interface/wrapper for GStreamer GstObject
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "object.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_OBJECT(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* Object::wrapperFactory(void *real) {
	return new Object(real);
}

Object::Object(void *real) :
	Wrapper(real),
	m_signalMap(0)
{
}

Object::~Object() {
	if (m_signalMap)
		delete m_signalMap;
}

Object* Object::wrap(void *real) {
	return (Object*) Wrapper::wrap(real);
}

void Object::setName(const QString &name) {
	gst_object_set_name(r(), name.latin1());
}

QString Object::name() const {
	return QString(gst_object_get_name(r()));
}
		
unsigned int Object::flags() const {
	return GST_FLAGS(r());
}

bool Object::flagIsSet(unsigned int flag) {
	return GST_FLAG_IS_SET(r(), flag);
}

void Object::flagSet(unsigned int flag) {
	GST_FLAG_SET(r(), flag);
}

void Object::flagUnset(unsigned int flag) {
	GST_FLAG_UNSET(r(), flag);
}

bool Object::floating() const {
	return GST_OBJECT_FLOATING(r());
}

bool Object::destroyed() const {
	return GST_OBJECT_DESTROYED(r());
}

void Object::lock() {
	GST_LOCK(r());
}

void Object::unlock() {
	GST_UNLOCK(r());
}

bool Object::tryLock() {
	return GST_TRYLOCK(r());
}

Object* Object::parent() const {
	return wrap(gst_object_get_parent(r()));
}

void Object::setParent(Object *parent) {
	gst_object_set_parent(r(), GST_OBJECT(parent->realObject()));
}

void Object::unparent() {
	gst_object_unparent(r());
}

QString Object::getPathString() const {
	return QString(gst_object_get_path_string(r()));
}

void Object::ref() {
	gst_object_ref(r());
}

void Object::unref() {
	gst_object_unref(r());
}

void Object::sink() {
	gst_object_sink(r());
}


#include "object.moc"

