/*
 *  Interface/wrapper for GStreamer GstThread
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "thread.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_PIPELINE(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* Thread::wrapperFactory(void *real) {
	return new Thread(real);
}

Thread::Thread(void *real) :
	Bin(real) {
}
Thread::~Thread() {
}

Thread* Thread::wrap(void *real) {
	return (Thread*) Bin::wrap(real);
}

Thread::Thread(const QString &name) :
	Bin(0) {
	m_real = gst_thread_new(name.latin1());
	registerReal();
}

#include "thread.moc"

