/*
 *  Widget-independent player class
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  Based on gst-player's play.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "kde/gstplay/videoscreen.h"

#include <qlayout.h>
#include <qxembed.h>

using namespace KDE::GSTPlay;

class KDE::GSTPlay::VideoScreenPrivate 
{
public:
	QXEmbed *xembed;
	QBoxLayout *videoLayout;
	Play *player;
	QSize size;
	
	VideoScreenPrivate(Play *player) :
		xembed(0),
		videoLayout(0),
		player(player) {
	}
	~VideoScreenPrivate() {
	}
};


VideoScreen::VideoScreen(Play *player, QWidget *parent, const char *name) :
	QWidget(parent,name) {

	d = new VideoScreenPrivate(player);
	d->videoLayout = new QHBoxLayout(this, 0);
	connect(player, SIGNAL(haveXId(int)), SLOT(haveXId(int)));
	connect(player, SIGNAL(haveVideoSize(int,int)), SLOT(haveVideoSize(int,int)));
}

VideoScreen::~VideoScreen() {
	delete d;
}

void VideoScreen::haveXId(int xid) {
	d->xembed = new QXEmbed(this);
	d->videoLayout->addWidget(d->xembed);
	d->xembed->embed(xid);
	d->xembed->show();
}

void VideoScreen::haveVideoSize(int w, int h) {
	d->size = QSize(w, h);
}

QSize VideoScreen::videoSize() const {
	return d->size;
}

#include "videoscreen.moc"
