/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_LISTPROPERTYDATAACTIONSERVICE_H
#define KHALKHI_LISTPROPERTYDATAACTIONSERVICE_H


// lib specific
#include "propertydataactionservice.h"

namespace KABC {
class AddresseeList;
}


namespace Khalkhi {

class ListPropertyDataActionServiceClient;


class KDE_EXPORT ListPropertyDataActionService : public PropertyDataActionService
{
    Q_OBJECT
public:
    ListPropertyDataActionService( QObject* Parent, const char* Name, const QStringList& Arguments );
    virtual ~ListPropertyDataActionService();

public: // interface
    virtual ServiceAction action( const KABC::AddresseeList &PersonList,
                                  QMimeSource *Data, int Flags ) const = 0;
    using PropertyDataActionService::action;

    /** does the service on the item with the given index from the supported person type */
    virtual void execute( const KABC::AddresseeList &PersonList, QMimeSource *Data ) = 0;
    using PropertyDataActionService::execute;

    /** @returns if the service is possible for the item; defaults to return true */
    virtual bool supports( QMimeSource *Data, const KABC::AddresseeList &PersonList ) const;
    using PropertyDataActionService::supports;

    /** @returns if the service is available currently for the item; defaults to return true */
    virtual bool isAvailableFor( QMimeSource *Data, const KABC::AddresseeList &PersonList ) const;
    using PropertyDataActionService::isAvailableFor;

    virtual void registerClient( ListPropertyDataActionServiceClient *Client );
    virtual void unregisterClient( ListPropertyDataActionServiceClient *Client );
    using PropertyDataActionService::registerClient;
    using PropertyDataActionService::unregisterClient;
};

}

#endif
