/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// kde specific
#include <kstaticdeleter.h>
// library specific
#include "propertyallactionserviceclient.h"
#include "allpropertiesglobalactionserviceclient.h"
#include "services_p.h"
#include "services.h"


namespace Khalkhi {

static Services* Master = 0;
static KStaticDeleter<Services> MasterDeleter;

Services *Services::self()
{
    if( Master == 0 )
        MasterDeleter.setObject( Master, new Services() );

    return Master;
}


Services::Services()
: d( new ServicesPrivate(this) )
{
    d->load();
}

const ServiceManager &Services::serviceManager() const
{ return d->serviceManager(); }

const PropertyManagerList &Services::propertyManagers() const
{ return d->PropertyManagers; }


void Services::registerClient( StatusServiceClient *Client )
{
    d->serviceManager().registerClient( Client );
}

void Services::unregisterClient( StatusServiceClient *Client )
{
    d->serviceManager().unregisterClient( Client );
}

void Services::registerClient( ActionServiceClient *Client )
{
    d->serviceManager().registerClient( Client );
}

void Services::unregisterClient( ActionServiceClient *Client )
{
    d->serviceManager().unregisterClient( Client );
}

void Services::registerClient( ListActionServiceClient *Client )
{
    d->serviceManager().registerClient( Client );
}

void Services::unregisterClient( ListActionServiceClient *Client )
{
    d->serviceManager().unregisterClient( Client );
}

void Services::execute( const KABC::Addressee &Person, const QString &ServiceId )
{
    d->serviceManager().execute( Person, ServiceId );
}
void Services::execute( const KABC::AddresseeList &PersonList, const QString &ServiceId )
{
    d->serviceManager().execute( PersonList, ServiceId );
}


void Services::registerClient( DataActionServiceClient *Client )
{
    d->serviceManager().registerClient( Client );
}

void Services::unregisterClient( DataActionServiceClient *Client )
{
    d->serviceManager().unregisterClient( Client );
}
void Services::registerClient( ListDataActionServiceClient *Client )
{
    d->serviceManager().registerClient( Client );
}

void Services::unregisterClient( ListDataActionServiceClient *Client )
{
    d->serviceManager().unregisterClient( Client );
}

void Services::execute( const KABC::Addressee &Person,
                                 const QString &ServiceId, QMimeSource *DataSource )
{
    d->serviceManager().execute( Person, DataSource, ServiceId );
}
void Services::execute( const KABC::AddresseeList &PersonList,
                                 const QString &ServiceId, QMimeSource *DataSource )
{
    d->serviceManager().execute( PersonList, DataSource, ServiceId );
}


void Services::registerClient( PropertyStatusServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->registerClient( Client );

    d->StatusServiceClients.append( Client );
}

void Services::unregisterClient( PropertyStatusServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->unregisterClient( Client );
	
    d->StatusServiceClients.remove( Client );
}

void Services::registerClient( AllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->registerClient( Client );

    d->GlobalActionServiceClients.append( Client );
}

void Services::unregisterClient( AllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->unregisterClient( Client );
	
    d->GlobalActionServiceClients.remove( Client );
}

void Services::registerClient( ListAllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->registerClient( Client );

    d->ListGlobalActionServiceClients.append( Client );
}

void Services::unregisterClient( ListAllPropertiesGlobalActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->unregisterClient( Client );
	
    d->ListGlobalActionServiceClients.remove( Client );
}


void Services::registerClient( PropertyAllActionServiceClient *Client )
{
    PropertyManager *Manager = d->PropertyManagers[Client->propertyId()];

    if( Manager )
        Manager->registerClient( Client );
}

void Services::unregisterClient( PropertyAllActionServiceClient *Client )
{
    PropertyManager *Manager = d->PropertyManagers[Client->propertyId()];

    if( Manager )
        Manager->unregisterClient( Client );
}

void Services::execute( const KABC::Addressee &Person, const QString &PropertyId, int ItemIndex,
                                 const QString &ServiceId )
{
    PropertyManager *Manager = d->PropertyManagers[PropertyId];

    if( Manager )
        Manager->execute( Person, ItemIndex, ServiceId );
}
void Services::execute( const KABC::AddresseeList &PersonList, const QString &PropertyId,
                                 const QString &ServiceId )
{
    PropertyManager *Manager = d->PropertyManagers[PropertyId];

    if( Manager )
        Manager->execute( PersonList, ServiceId );
}


void Services::registerClient( AllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->registerClient( Client );

    d->GlobalDataActionServiceClients.append( Client );
}

void Services::unregisterClient( AllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->unregisterClient( Client );

    d->GlobalDataActionServiceClients.remove( Client );
}

void Services::registerClient( ListAllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->registerClient( Client );

    d->ListGlobalDataActionServiceClients.append( Client );
}

void Services::unregisterClient( ListAllPropertiesGlobalDataActionServiceClient *Client )
{
    for( PropertyManagerList::Iterator ManagerIt = d->PropertyManagers.begin();
         ManagerIt != d->PropertyManagers.end(); ++ManagerIt )
        (*ManagerIt)->unregisterClient( Client );

    d->ListGlobalDataActionServiceClients.remove( Client );
}


void Services::registerClient( PropertyAllDataActionServiceClient *Client )
{
    PropertyManager *Manager = d->PropertyManagers[Client->propertyId()];

    if( Manager )
        Manager->registerClient( Client );
}

void Services::unregisterClient( PropertyAllDataActionServiceClient *Client )
{
    PropertyManager *Manager = d->PropertyManagers[Client->propertyId()];

    if( Manager )
        Manager->unregisterClient( Client );
}


void Services::execute( const KABC::Addressee &Person, const QString &PropertyId, int ItemIndex,
                                 const QString &ServiceId, QMimeSource *Event )
{
    PropertyManager *Manager = d->PropertyManagers[PropertyId];

    if( Manager )
        Manager->execute( Person, ItemIndex, Event, ServiceId );
}

void Services::execute( const KABC::AddresseeList &PersonList, const QString &PropertyId,
                                 const QString &ServiceId, QMimeSource *Event )
{
    PropertyManager *Manager = d->PropertyManagers[PropertyId];

    if( Manager )
        Manager->execute( PersonList, Event, ServiceId );
}

Services::~Services() {}

}

#include "services.moc"
