/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_SERVICES_H
#define KHALKHI_SERVICES_H


// lib specific
#include "kidptrvector.h"
#include "propertymanager.h"
#include "servicemanager.h"

class QMimeSource;


namespace Khalkhi {

class ServicesPrivate;
class ServiceManager;
class PropertyManager;

typedef KIdPtrVector<PropertyManager> PropertyManagerList;


class KDE_EXPORT Services : public QObject
{
    friend class ServicesPrivate;

    Q_OBJECT

public:
    static Services *self();

protected:
    Services();
public:
    virtual ~Services();

public: // status interface
    void registerClient( StatusServiceClient *Client );
    void unregisterClient( StatusServiceClient *Client );

public: // action service interface
    /** does the service id */
    void execute( const KABC::Addressee &Person, const QString &ServiceId );
    void execute( const KABC::AddresseeList &PersonList, const QString &ServiceId );

    void registerClient( ActionServiceClient *Client );
    void unregisterClient( ActionServiceClient *Client );
    void registerClient( ListActionServiceClient *Client );
    void unregisterClient( ListActionServiceClient *Client );

public: // data action service interface
    /** does the service id */
    void execute( const KABC::Addressee &Person, const QString &ServiceId, QMimeSource *DataSource );
    void execute( const KABC::AddresseeList &PersonList, const QString &ServiceId, QMimeSource *DataSource );

    void registerClient( DataActionServiceClient *Client );
    void unregisterClient( DataActionServiceClient *Client );
    void registerClient( ListDataActionServiceClient *Client );
    void unregisterClient( ListDataActionServiceClient *Client );

public: // status interface
    void registerClient( PropertyStatusServiceClient *Client );
    void unregisterClient( PropertyStatusServiceClient *Client );

public: // action service interface
    /** does the service id on the item with the given index of the supported type */
    void execute( const KABC::Addressee &Person, const QString &PropertyId, int ItemIndex,
                  const QString &ServiceId );
    void execute( const KABC::AddresseeList &PersonList, const QString &PropertyId,
                  const QString &ServiceId );

    void registerClient( PropertyAllActionServiceClient *Client );
    void unregisterClient( PropertyAllActionServiceClient *Client );

    void registerClient( AllPropertiesGlobalActionServiceClient *Client );
    void unregisterClient( AllPropertiesGlobalActionServiceClient *Client );

    void registerClient( ListAllPropertiesGlobalActionServiceClient *Client );
    void unregisterClient( ListAllPropertiesGlobalActionServiceClient *Client );

public: // data action service interface
    void execute( const KABC::Addressee &Person, const QString &PropertyId, int ItemIndex,
                  const QString &ServiceId, QMimeSource *DataSource );
    void execute( const KABC::AddresseeList &PersonList, const QString &PropertyId,
                  const QString &ServiceId, QMimeSource *DataSource );

    void registerClient( PropertyAllDataActionServiceClient *Client );
    void unregisterClient( PropertyAllDataActionServiceClient *Client );

    void registerClient( AllPropertiesGlobalDataActionServiceClient *Client );
    void unregisterClient( AllPropertiesGlobalDataActionServiceClient *Client );

    void registerClient( ListAllPropertiesGlobalDataActionServiceClient *Client );
    void unregisterClient( ListAllPropertiesGlobalDataActionServiceClient *Client );

public: // management interface
    const ServiceManager &serviceManager() const;
    const PropertyManagerList &propertyManagers() const;

signals:
    /** emitted whenever something in the configuration changes */
    void changed();

protected:
    ServicesPrivate *d;
};

}

#endif
