/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXCALLREGISTERITEM_H
#define KIAXCALLREGISTERITEM_H

#include <stdarg.h>

#include <qlistbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpainter.h>
#include <qstyle.h>
#include <qapplication.h>
#include <qobject.h>
#include "kiaxcallrecord.h"
#include <stdlib.h>

class KiaxCallRegisterItem : public QListBoxItem, QObject
{

public:
    KiaxCallRegisterItem(KiaxCallRecord* rec, QString iconsPath);
    virtual void paint( QPainter * );
    virtual int width( const QListBox* lb) const;
    virtual int height( const QListBox* lb) const;
    ~KiaxCallRegisterItem();
    const QPixmap *pixmap() const { return &pm; }

private:

    QPixmap pm;
    QString durationString;
    QString dateString;
    QString cidName;
    QString cidNumber;
    QString accId;

signals:


};

#endif
