/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2010-2015 Jean-Pierre Charras, jean-pierre.charras at wanadoo.fr
 * Copyright (C) 1992-2015 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef DIALOG_EDIT_FOOTPRINT_FOR_MODEDIT_H
#define DIALOG_EDIT_FOOTPRINT_FOR_MODEDIT_H

// Include the wxFormBuider header base:
#include <vector>
#include <dialog_edit_footprint_for_fp_editor_base.h>

class PANEL_PREV_3D;
class MODULE;

class DIALOG_FOOTPRINT_FP_EDITOR : public DIALOG_FOOTPRINT_FP_EDITOR_BASE
{
private:

    FOOTPRINT_EDIT_FRAME*       m_parent;
    MODULE*                     m_currentModule;
    TEXTE_MODULE*               m_referenceCopy;
    TEXTE_MODULE*               m_valueCopy;
    std::vector<MODULE_3D_SETTINGS>       m_shapes3D_list;
    int                         m_lastSelected3DShapeIndex;
    static size_t               m_page;         // remember the last open page during session
    PANEL_PREV_3D*              m_PreviewPane;
    MODULE*                     m_currentModuleCopy;
    LIB_ID                      m_currentFPID;  // the full initial FPID

public:

    // Constructor and destructor
    DIALOG_FOOTPRINT_FP_EDITOR( FOOTPRINT_EDIT_FRAME* aParent, MODULE* aModule );
    ~DIALOG_FOOTPRINT_FP_EDITOR();

private:
    void BrowseAndAdd3DShapeFile();
    void initModeditProperties();
    void Edit3DShapeFileName();

    // virtual event functions
    void OnEditValue( wxCommandEvent& event ) override;
    void OnEditReference( wxCommandEvent& event ) override;
    void On3DShapeSelection( wxCommandEvent& event );
    void On3DShapeNameSelected( wxCommandEvent& event ) override;
    void Add3DShape( wxCommandEvent& event ) override
    {
        BrowseAndAdd3DShapeFile();
    }
    void Remove3DShape( wxCommandEvent& event ) override;
    void Edit3DShapeFilename( wxCommandEvent& event ) override
    {
        Edit3DShapeFileName();
    }

    void Cfg3DPath( wxCommandEvent& event ) override;

    bool TransferDataFromWindow() override;

    void OnInitDlg( wxInitDialogEvent& event ) override
    {
        // Call the default wxDialog handler of a wxInitDialogEvent
        TransferDataToWindow();

        // Now all widgets have the size fixed, call FinishDialogSettings
        FinishDialogSettings();
    }
};


#endif      //  DIALOG_EDIT_FOOTPRINT_FOR_MODEDIT_H
