# bootstrap setuptools if necessary
from ez_setup import use_setuptools
use_setuptools()

import kid as package

package_name = package.__name__
package_version = package.__version__
doc_parts = package.__doc__.strip().splitlines()

from setuptools import setup
setup(
    name=package_name,
    version=package_version,
    description= "A simple and pythonic XML template language",
    author="Ryan Tomayko",
    author_email="rtomayko@lesscode.org",
    license="MIT",
    long_description = '\n'.join(doc_parts[2:]),
    keywords = "xml template html web",
    url = "http://%s.lesscode.org/" % package_name,
    download_url = "http://kid.lesscode.org/dist/%s/kid-%s.tar.gz" % \
                   (package_version, package_version),
    scripts = ['bin/kidc', 'bin/kid'],
    py_modules=[],
    packages=[package_name,
              package_name + '.test'],
    install_requires=['elementtree'],
    classifiers = [
            'Development Status :: 4 - Beta',
            'Environment :: Console',
            'Environment :: Web Environment',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: MIT License',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Topic :: Internet :: WWW/HTTP',
            'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
            'Topic :: Software Development :: Libraries :: Python Modules',
            'Topic :: Text Processing :: Markup :: XML'
        ])
