# Add rule to generate _headerFilename.gch from _headerFilename and
# add it to _srcList
macro (ADD_PCH_RULE _headerFilename _srcList _additionalFlags)
  set(_gchFilename "${_headerFilename}.gch")
  list(APPEND ${_srcList} ${_gchFilename})
  list(APPEND _args -c ${_headerFilename} -o ${_gchFilename} ${_additionalFlags})
  get_directory_property(_dirinc INCLUDE_DIRECTORIES)
  foreach (_inc ${_dirinc})
    list(APPEND _args "-I" ${_inc})
  endforeach(_inc ${_dirinc})
  separate_arguments(_args)
  add_custom_command(OUTPUT ${_gchFilename}
       COMMAND ${CMAKE_COMMAND} -E remove ${_gchFilename}
       COMMAND ${CMAKE_CXX_COMPILER} ${CMAKE_CXX_COMPILER_ARG1} ${_args}
          DEPENDS ${_headerFilename})
endmacro(ADD_PCH_RULE _headerFilename _srcList)

# Add rule to generate _headerFilename with system includes from
# includes used in _srcDir.
macro (ADD_PCH_HEADERFILE_RULE _headerFilename _srcDir _includeRegex)
  add_custom_command(OUTPUT ${_headerFilename}
    COMMAND ${CMAKE_COMMAND} -DSCRIPT_ARG_HEADER_FILENAME=${_headerFilename}
      -DSCRIPT_ARG_SRC_DIRNAME=${_srcDir}
      -DSCRIPT_ARG_INCLUDE_REGEX="${_includeRegex}"
      -P ${CMAKE_SOURCE_DIR}/GccPchMacros.cmake)
endmacro (ADD_PCH_HEADERFILE_RULE _srcDir _headerFilename)

# This part is only run when started as a script with definitions
# SCRIPT_ARG_HEADER_FILENAME and SCRIPT_ARG_SRC_DIRNAME as used in
# ADD_PCH_HEADERFILE_RULE.
if (SCRIPT_ARG_HEADER_FILENAME AND SCRIPT_ARG_SRC_DIRNAME)
  set(_headerFilename ${SCRIPT_ARG_HEADER_FILENAME})
  if (SCRIPT_ARG_INCLUDE_REGEX)
    set(_includeRegex ${SCRIPT_ARG_INCLUDE_REGEX})
  else (SCRIPT_ARG_INCLUDE_REGEX)
    set(_includeRegex "#include <")
  endif (SCRIPT_ARG_INCLUDE_REGEX)
  file(GLOB_RECURSE _srcList "${SCRIPT_ARG_SRC_DIRNAME}/*.cpp"
                     "${SCRIPT_ARG_SRC_DIRNAME}/*.hpp"
                     "${SCRIPT_ARG_SRC_DIRNAME}/*.c"
                     "${SCRIPT_ARG_SRC_DIRNAME}/*.h")
  set(_includes)
  foreach (_src ${_srcList})
    file(STRINGS ${_src} _inc REGEX ${_includeRegex})
    if (NOT "${_inc}" MATCHES "#include .config\\.h.")
      list(APPEND _includes ${_inc})
    endif()
  endforeach (_src ${_srcList})
  list(SORT _includes)
  list(REMOVE_DUPLICATES _includes)
  set(_txt "/* automatically generated by GccPchMacros.cmake */\n"
           "#ifndef ALLSYS_H\n"
           "#define ALLSYS_H\n"
           "#ifdef __cplusplus\n")
  foreach(_inc ${_includes})
    set(_txt "${_txt}${_inc}\n")
  endforeach(_inc _includes)
  set(_txt "${_txt}#endif\n#endif\n")
  file(WRITE ${_headerFilename} ${_txt})
  message(STATUS "Generating ${_headerFilename}")
endif (SCRIPT_ARG_HEADER_FILENAME AND SCRIPT_ARG_SRC_DIRNAME)
