/* $Id: we_misc.c,v 1.16 2005/11/03 19:42:42 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gmodule.h>

#include "simocombobox.h"

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


GtkWidget *
get_we_misc_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel    = glade_xml_get_widget(gladexml, "we_panel_misc");

  return panel;
}


void
fill_we_misc_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *chkScrollOutput;
  GtkWidget *txtBufferLines;

  if (!world) {
    return;
  }

  /* Get widgets */
  chkScrollOutput = glade_xml_get_widget(gladexml, "chkScrollOutput");
  txtBufferLines  = glade_xml_get_widget(gladexml, "txtBufferLines");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkScrollOutput),
                               world->scrollOutput);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(txtBufferLines),
                            world->buffer_lines);
}



void
update_we_misc_parameters(World *world)
{
  GladeXML  *gladexml;
  GtkWidget *chkScrollOutput;
  GtkWidget *txtBufferLines;

  /* Get widgets */
  gladexml        = glade_get_widget_tree(world->dlgEditWorld);
  chkScrollOutput = glade_xml_get_widget(gladexml, "chkScrollOutput");
  txtBufferLines  = glade_xml_get_widget(gladexml, "txtBufferLines");

  world->scrollOutput =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chkScrollOutput));

  world->buffer_lines =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(txtBufferLines));
}
