/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "i8ksrc.h"
#include <qtextstream.h> 
#include <qdir.h>
#include <klocale.h>

I8kSrc::I8kSrc(QWidget* inParent, const QFile& inSourceFile, unsigned int inIndex):
		LabelSource(inParent),
		mIndex(inIndex),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = I8kSrc::index2Name(inIndex);
	mName = mID;
	mDescription = i18n("This source is provided by i8k kernel module.");
}

I8kSrc::~I8kSrc(){
}

std::list<Source*>I8kSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QFile i8kFile("/proc/i8k");
	if(i8kFile.open(IO_ReadOnly)){
		QTextStream textStream(&i8kFile);
		QString s = textStream.readLine();
		i8kFile.close();
		QStringList entries = QStringList::split(' ', s);
		if(entries.size() && entries[0] == "1.0"){ // support for version 1.0
			// CPU temp
			if(entries.size() >= 4 && !entries[3].startsWith("-"))
				list.push_back(new I8kSrc(inParent, i8kFile, 3));
			// left fan
			if(entries.size() >= 7 && !entries[4].startsWith("-"))
				list.push_back(new I8kSrc(inParent, i8kFile, 6));
			// left fan
			if(entries.size() >= 8 && !entries[5].startsWith("-"))
				list.push_back(new I8kSrc(inParent, i8kFile, 7));
		}
	}
	return list;	
}
QString I8kSrc::fetchValue(){
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		QTextStream textStream(&mSourceFile);
		s = textStream.readLine();
		mSourceFile.close();
		s = s.section(' ', mIndex, mIndex, QString::SectionSkipEmpty).stripWhiteSpace();
		switch(mIndex){
		case 3: // CPU temperature (Celsius)
			s = formatTemperature(s);
			break;
		case 6: // left fan rpm
		case 7: // right fan rpm
			if(s.length() > 1)
				s.truncate(s.length() - 1); //s = QString::number(s.toInt()/10);
			s.append(" rpm");
			break;
		default:
			break;
		}
	}
	return s;
}

QString I8kSrc::index2Name(unsigned int inIndex){
	switch(inIndex){
	case 0: // /proc/i8k format version
		return "i8k Format Version";
	case 1: // BIOS version
		return "Bios"; 
	case 2: // serial number
		return "Serial";
	case 3: // CPU temperature (Celsius)
		return "CPU";
	case 4: // left fan status
		return "left Fan Status";
	case 5: // right fan status
		return "right Fan Status";
	case 6: // left fan rpm
		return "left Fan";
	case 7: // right fan rpm
		return "right Fan";
	case 8: // ac status
		return "AC Status";
	case 9: // buttons status
		return "Button Status";
	default:
		return "unknown" + QString().setNum(inIndex);
	}
}

