/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef NVIDIATHERMALSRC_H
#define NVIDIATHERMALSRC_H

#include <config.h>
#include "labelsource.h"
#include <list>
#include <qtimer.h>

class KProcIO;
/**
 * NVidiaThermalSrc calls nvidia-settings to fetch the thermal values of the GPU
 * @author Ken Werner
 */
class NVidiaThermalSrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File
	 */
#ifndef HAVE_NVCONTROL
	NVidiaThermalSrc(QWidget* inParent, const QString& inID, const QString& inName);
#else
    NVidiaThermalSrc(QWidget* inParent, const QString& inID, const QString& inName, unsigned int attrib);
#endif
	virtual ~NVidiaThermalSrc();
	
	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);

	/**
	 * runs the nvidia-settings command
	 */
	virtual QString fetchValue();

protected slots:
	/**
	 * enables (starts the timer) or disables (stops the timer)
	 * this method is called if mSource gets enabled or disabled
	 */
	void enable(bool inEnable);

private:
#ifndef HAVE_NVCONTROL
    /**
     * create mProcess and connects its exited signal to
     * the evaluateStdout slot.
     */
    void createProcess();
	KProcIO* mProcess;
#else
    unsigned int mAttrib;
#endif
	/**
	 * The refresh timer
	 */
	QTimer* mRefreshTimer;

private slots:
	/**
	 * updates the label
	 */
	virtual void evaluateStdout();
};
#endif //NVIDIATHERMALSRC_H
