
namespace eval svc {
    proc getExportDir { svcID N E } { return 1 }
    proc getExportClient { svcID N E C } { return 1 }
    proc getExportOptions { svcID N E C } { return 1 }

    proc setExportDir { svcID N E dirname } { return 1 }
    proc setExportClient { svcID N E C clientName } { return 1 }
    proc setExportOptions { svcID N E C clientOptions } { return 1 }

    proc ckExportClient { client } { return 1 } 
    proc ckExportOptions { options } { return 1 }

    proc ckExportDir { exportDir } { return 1 }
    # add an empty assignNFSserverDir proc
    proc assignNFSserverDir { id } { return 1 }
    proc renameExportDirs { svc oldMountPoint newMountPoint } { return 1 }
}

namespace eval Service {

    # Exports
    proc _addmodifyordelete_export { serviceID deviceID resarrayin } {
    }

    # Exports
    # from file proprietary.tcl: _addmodifyordelete_export 
    proc _addexport { serviceID deviceID resarrayin } {
    }
    proc _modifyexport { serviceID deviceID exportID resarrayin } {
    }
    proc _whichexport { what serviceID deviceID resarrayin } {
    }
    proc _showexports { serviceID deviceID resarrayin } {
    }        
    proc _deleteexport { serviceID deviceID exportID resarrayin } {
    }

    proc _addmodifyordelete_client { serviceID 
                                     deviceID 
                                     directoryID 
                                     resarrayin } {
    }
    proc _addclient { serviceID deviceID directoryID resarrayin } {
    }
    proc _modifyclient { serviceID deviceID directoryID clientID resarrayin } {
    }
    proc _whichclient { what serviceID deviceID directoryID resarrayin } {
    }
    proc _showclients { serviceID deviceID directoryID resarrayin } {
    }
    proc _deleteclient { serviceID deviceID clientID resarrayin } {
    }
    proc _listexportIDs { serviceID deviceID resarrayin } {
        return {}
    }
    proc _listclientIDs { serviceID deviceID directoryID resarrayin } {
        return {}
    }
    proc _countexports { serviceID deviceID resarrayin } {
        return 0
    }
    proc _countclients { serviceID deviceID directoryID resarrayin } {
        return 0
    }
    proc _nextexportID { serviceID deviceID resarrayin } {
    }
    proc _nextclientID { serviceID deviceID exportID resarrayin} {
    }

    proc _spewMountPointChangedMessage {} {
    }
    # Whew, this is wild.  Print out the values, formatted, for each
    # field associated with the given service.  Get the values from
    # the array, if one is passed, and prefer those values, otherwise
    # get the values from the svc namespace, and print those, unless
    # they are NULL.  If there is no entry in the array, and the svc
    # namespace call returns NULL, don't print anything.
    proc format { service { arrayname "__not_set__" }} {
        if { ![string match "__not_set__" $arrayname] } {
            upvar $arrayname array
        } else {
            array set array {}
        }
        set id [svc::getID $service] ;# should be able to
        # specify
        if { -1 == $id } {
            error "Unknown service: $service"
        }
        pv "in format, " service id
        # Print out the attributes of the service if they come
        # back non-null from the svc interface.
        #
        _print_either "name: " \
            [_lookup [svc::nameToken $id] array] \
            [_fetch getName]
        _print_either "disabled: " \
            [_map_yes_or_no [_lookup [svc::disabledToken $id] array]] \
            [_fetch getDisabled]
        _print_either "preferred node: " \
            [_map_member_id_to_name [_lookup [svc::preferredNodeNameToken $id] array]] \
            [_fetch getPreferredNodeName]
        _print_either "relocate: " \
            [_map_yes_or_no [_lookup [svc::relocateOnPreferredNodeBootToken $id] array]] \
            [_fetch getRelocateOnPreferredNodeBoot]
        _print_either "user script: " \
            [_lookup [svc::scriptToken $id] array] \
            [_fetch getScript]
        foreach {i} [lsort -integer [_listnetworkIDs $id array]] {
            _print_either "IP address $i: " \
                [_lookup [svc::IPaddressToken $id $i] array] \
                [_fetch getIPaddress $i]
            _print_either "  netmask $i: " \
                [_lookup [svc::netmaskToken $id $i] array] \
                [_fetch getNetmask $i]
            _print_either "  broadcast $i: " \
                [_lookup [svc::broadcastToken $id $i] array] \
                [_fetch getBroadcast $i]
        }
        foreach i [lsort -integer [_listdeviceIDs $id array]] {
            _print_either "device $i: " \
                [_lookup [svc::deviceToken $id $i] array] \
                [_fetch getDevice $i]
            if { ![string match "NULL" [_lookup [svc::mountPointToken $id $i] array]] ||
                 ![string match "NULL" [_fetch getMountPoint $i]]} {
                _print_either "  mount point, device $i: " \
                    [_lookup [svc::mountPointToken $id $i] array] \
                    [_fetch getMountPoint $i]
                _print_either "  mount fstype, device $i: " \
                     [_lookup [svc::mountFstypeToken $id $i] array] \
                     [_fetch getMountFstype $i]
                _print_either "  mount options, device $i: " \
                    [_lookup [svc::mountOptionsToken $id $i] array] \
                    [_fetch getMountOptions $i]
                _print_either "  force unmount, device $i: " \
                    [_map_yes_or_no [_lookup [svc::forceUnmountToken $id $i] array]] \
                    [_fetch getForceUnmount $i]
                _print_either "  owner, device $i: " \
                    [_lookup [svc::deviceOwnerToken $id $i] array] \
                    [_fetch getDeviceOwner $i]
                _print_either "  group, device $i: " \
                    [_lookup [svc::deviceGroupToken $id $i] array] \
                    [_fetch getDeviceGroup $i]
                _print_either "  mode, device $i: " \
                    [_lookup [svc::deviceModeToken $id $i] array] \
                    [_fetch getDeviceMode $i]

            }
        }
    }
    # Fairly monstrous.  Given an array pointed to by arrayname, and a
    # service name, look up the items in the array, and for each of
    # them, call the correct setter in the svc namespace.  After this
    # is done, I presume that the database has been updated and that
    # there is nothing more to be done,
    proc write { service arrayname modify } {
        upvar $arrayname array
        set id [svc::getID $service] ;# should be able to
        # specify
        if { -1 == $id } {
            error "Unknown service: $service"
        }
        pv "in format, " service id
        # Print out the attributes of the service if they come
        # back non-null from the svc interface.
        #
        if { ! $modify } {
            _set_if \
                [_lookup [svc::nameToken $id] array] \
                $id setName
        }
        _set_if \
            [_map_yes_or_no [_lookup [svc::disabledToken $id] array]] \
            $id setDisabled
        _set_if_not_none \
            [_map_member_id_to_name [_lookup [svc::preferredNodeNameToken $id] array]] \
            $id setPreferredNodeName
        _set_if \
            [_map_yes_or_no [_lookup [svc::relocateOnPreferredNodeBootToken $id] array]] \
            $id setRelocateOnPreferredNodeBoot
        _set_if_not_none \
            [_lookup [svc::scriptToken $id] array] \
            $id setScript
        foreach {i} [lsort -integer [_listnetworkIDs $id array]] {
            _set_if \
                [_lookup [svc::IPaddressToken $id $i] array] \
                $id setIPaddress $i
            _set_if_not_none \
                [_lookup [svc::netmaskToken $id $i] array] \
                $id setNetmask $i
            _set_if_not_none \
                [_lookup [svc::broadcastToken $id $i] array] \
                $id setBroadcast $i
        }
        foreach i [lsort -integer [_listdeviceIDs $id array]] {
            _set_if \
                [_lookup [svc::deviceToken $id $i] array] \
                $id setDevice $i
            if { ![string match "NULL" [_lookup [svc::mountPointToken $id $i] array]]} {
                _set_if \
                    [_lookup [svc::mountPointToken $id $i] array] \
                    $id setMountPoint $i
                _set_if \
                    [_lookup [svc::mountFstypeToken $id $i] array] \
                    $id setMountFstype $i
                _set_if \
                    [_lookup [svc::mountOptionsToken $id $i] array] \
                    $id setMountOptions $i
                _set_if \
                    [_map_yes_or_no [_lookup [svc::forceUnmountToken $id $i] array]] \
                    $id setForceUnmount $i
                _set_if \
                    [_lookup [svc::deviceOwnerToken $id $i] array] \
                    $id setDeviceOwner $i
                _set_if \
                    [_lookup [svc::deviceGroupToken $id $i] array] \
                    $id setDeviceGroup $i
                _set_if \
                    [_lookup [svc::deviceModeToken $id $i] array] \
                    $id setDeviceMode $i

            }
        }
    }

}

