/*
 * Copyright (C) 2000 Mission Critical Linux
 *
 * All Rights Reserved. Unpublished rights reserved under the
 * copyright laws of the United States. This software and all
 * associated intellectual property embodies the confidential
 * technology of Mission Critical Linux LLC. Possession, use,
 * duplication or dissemination of the software is authorized
 * only pursuant to a valid written license from Mission
 * Critical Linux LLC.
 *
 * Author: Kris Corwin <Corwin@MissionCriticalLinux.Com>
 *
 * gratuitousarp.c

 *
 * Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
 * svcmgr_proto.h
 * $Revision: 1.5 $
 */

/*
 * Function prototypes
 */

extern char *serviceActionStrings[];

/* svcmgr.c */
void svcmgr_SIGTERM_handler(void);
void svcmgr_SIGUSR1_handler(void);
void svcmgr_SIGHUP_handler(void);
void svcmgr_SIGSEGV_handler(void);
void svcmgr_SIGBUS_handler(void);
void svcmgr_SIGCHLD_handler(void);
void svcmgrExit(int status);
void svcmgrDumpCore(char *reason);
int sendImAliveMsg(void);
int getNodeState(int nodeID);
void rebootSystem(char *reason);
int systemShuttingDown(void);

/* svc_engine.c */
int nodeChange(int nodeID, int nodeStatus);

/* svc_state.c */
int stopAllServices(void);
int reqStartService(int svcID, int waitFlag);
int reqWaitAndStartService(int svcID);
int reqStopService(int svcID, int waitFlag);
int reqWaitAndStopService(int svcID);
