

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.7 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
#
#------------------------------------------------------------

#
# KornShell logging library functions.
#

#-----------------------------------------------------------------------------
# Globals
#-----------------------------------------------------------------------------

#
# Logging states (DEFAULT_LOGLEVEL should be the same as svcmgr.h)
#
LOG_EMERG=0	# system is unusable
LOG_ALERT=1	# action must be taken immediately
LOG_CRIT=2	# critical conditions
LOG_ERR=3	# error conditions
LOG_WARNING=4	# warning conditions
LOG_NOTICE=5	# normal but significant condition
LOG_INFO=6	# informational
LOG_DEBUG=7	# debug-level messages
DEFAULT_LOGLEVEL=$LOG_NOTICE	# default log level of Service Manager

#-----------------------------------------------------------------------------
# Functions
#-----------------------------------------------------------------------------

logAndPrint() {

	typeset svcmgr_loglevel
	typeset logline

	if [ $# -lt 1 ]; then
		print -u2 "$MYNAME Error: Usage logAndPrint log_level string"
		return $ERROR
	fi

	typeset MYNAME=$(basename $0)
	typeset level=$1
	shift
	
	case "$level" in
	  $LOG_EMERG)	log_level="emergency";;
	  $LOG_ALERT)	log_level="alert";;
	  $LOG_CRIT)	log_level="critcal";;
	  $LOG_ERR)	log_level="error";;
	  $LOG_WARNING)	log_level="warning";;
	  $LOG_NOTICE)	log_level="notice";;
	  $LOG_INFO)	log_level="info";;
	  $LOG_DEBUG)	log_level="debug";;
	  *)
	    print -u2 "$MYNAME logAndPrint: unknown log level '$level'"
	    log_level="Unknown" ;;
	esac

	svcmgr_loglevel=$(getSvcMgrLogLevel $DB)
	retVal=$?
	case $retVal in
	0)  ;;
	2)  svcmgr_loglevel=$DEFAULT_LOGLEVEL;;
	*)  svcmgr_loglevel=$DEFAULT_LOGLEVEL
	    print "Cannot get Service Manager log level; error=$retVal"
	    ;;
	esac

	logline="$MYNAME $log_level: $*"

	$CLULOG -p $$ -n $SVCMGR_STR -s $level "$logline" # print to cluster log

	if [ -n "$level" -a -n "$svcmgr_loglevel" \
	     -a $level -le $svcmgr_loglevel ]; then
	  print "$log_level: $*"	# print to stdout
	fi
}

debug_print() {
	if [ -n "$DEBUG" ]; then
	  print -u2 $*		# print to stderr
	fi
}
