

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.5.2.1 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
# 
#------------------------------------------------------------

#
# KornShell API for access to the cluster database.  Since the Service
# Manager does not directly modify services there are no setSvc*()
# functions in this file.  The Service Manager only needs to read the
# information and use it for service configuration.
#

#
# Get the log level of the Service Manager
#
getSvcMgrLogLevel ()
{
	typeset DB=$1

	# svcmgr%logLevel
	$GETCONFIG -f $DB $SVCMGR_STR$SEP$SVCMGR_LOGLEVEL_STR
	return $?
}

#
# Given a service ID get its associated service name from the given database.
#
getSvcName ()
{
	typeset DB=$1
	typeset svcID=$2

	# services%service0%name
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_NAME_STR
	return $?
}

#
# Given a service ID get its associated user script from the given database.
#
getSvcUserScript ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%userScript
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_USER_SCRIPT_STR
	return $?
}

#
# Given a service ID get the Nth IP address from the given database.
#
getSvcIPaddress ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%network0%ipAddress
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_NETWORK_STR$N$SEP$SVC_IP_ADDR_STR
	return $?
}

#
# Given a service ID get the Nth IP address from the given database.
#
getSvcNetmask ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%network0%netmask
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_NETWORK_STR$N$SEP$SVC_NETMASK_STR
	return $?
}

#
# Given a service ID get the Nth IP address from the given database.
#
getSvcBroadcast ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%network0%broadcast
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_NETWORK_STR$N$SEP$SVC_BROADCAST_STR
	return $?
}

#
# Given a service ID get the Nth device name from the given database.
#
getSvcDevice()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%name
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_DEVICE_NAME_STR
	return $?
}

#
# Given a service ID get the Nth mount point from the given database.
#
getSvcMountPoint()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%mount%name
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_MOUNT_STR$SEP$SVC_MOUNT_NAME_STR
	return $?
}

#
# Given a service ID get the Nth mount point fstype from the given database.
#
getSvcMountFstype ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%mount%fstype
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_MOUNT_STR$SEP$SVC_MOUNT_FSTYPE_STR
	return $?
}

#
# Given a service ID get the Nth mount point options from the given database.
#
getSvcMountOptions ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%mount%options
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_MOUNT_STR$SEP$SVC_MOUNT_OPTIONS_STR
	return $?
}

#
# Given a service ID get the Nth forced unmount setting from the given database.
#
getSvcForceUnmount ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%mount%options
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_MOUNT_STR$SEP$SVC_FORCE_UNMOUNT_STR
	return $?
}

#
# Given a service ID get the Nth device owner from the given database.
#
getSvcDeviceOwner ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%owner
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_DEVICE_OWNER_STR
	return $?
}

#
# Given a service ID get the Nth device group from the given database.
#
getSvcDeviceGroup ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%group
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_DEVICE_GROUP_STR
	return $?
}

#
# Given a service ID get the Nth device mode from the given database.
#
getSvcDeviceMode ()
{
	typeset DB=$1
	typeset svcID=$2
	typeset N=$3

	# services%service0%device0%mode
	$GETCONFIG -f $DB \
	$SVC_SERVICES_LIST_STR$SEP$SVC_SERVICE_STR$svcID$SEP$SVC_DEVICE_STR$N$SEP$SVC_DEVICE_MODE_STR
	return $?
}
