#!/bin/sh

function usage
{
	# Title
	echo "Title: FFMPEG DVD-Video Export"

	# Usable?
	which ffmpeg > /dev/null
	[ $? = 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo "Profile: Output Standard VOB"
	echo "Profile: Output Widescreen VOB (source must be widescreen)"
	which dvdauthor > /dev/null
	if [ $? = 0 ]; then
		echo "Profile: Output Standard DVD-Video directory (All only)"
		echo "Profile: Output Widescreen DVD-Video directory (All only)"
	fi
}

function execute
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="`dirname "$4"`/`basename "$4"`"
	smil_file="$5"

	# Determine info arguments
	frame_rate=`[ "$normalisation" = "pal" ] && echo 25 || echo 29.97`
	audio_format=`[ "$normalisation" = "pal" ] && echo mp2 || echo ac3`
	audio_bitrate=`[ "$normalisation" = "pal" ] && echo 224 || echo 192`

	# Build path to extract_chapters Perl script
	get_chapters="`dirname $0`/extract_chapters"

	# Prepare temporary files
	M2V=`mktemp $file.XXXXXX`
	AC3=`mktemp $file.XXXXXX`

	# Run the command
	case "$profile" in
		"0" )
			ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
			-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
			ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s $normalisation -r $normalisation -i pipe: \
			-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -y "$M2V"
			mplex -v 0 -f 8 -o "$file" "$M2V" "$AC3"
			;;
		"1" )
			ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
			-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
			ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s $normalisation -r $normalisation -i pipe: \
			-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -y "$M2V"
			mplex -v 0 -f 8 -o "$file" "$M2V" "$AC3"
			;;
		"2" )
			VOB=`mktemp -u $file.XXXXXX`
			mkfifo "$VOB"
			rm -rf "$file"
			ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
			-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
			ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s $normalisation -r $normalisation -i pipe: \
			-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 4:3 -y "$M2V"
			mplex -v 0 -f 8 -o "$VOB" "$M2V" "$AC3" &
			dvdauthor -o "$file" --chapters=`$get_chapters -f $frame_rate -x $smil_file` "$VOB"
			dvdauthor -o "$file" -T
			rm -f "$VOB"
			;;
		"3" )
			VOB=`mktemp -u $file.XXXXXX`
			mkfifo "$VOB"
			rm -rf "$file"
			ffmpeg -v 0 -f dv -i pipe: -f rawvideo -pix_fmt yuv420p pipe: \
			-vn -f $audio_format -ac 2 -ab $audio_bitrate -ar 48000 -y "$AC3" | \
			ffmpeg -v 0 -f rawvideo -pix_fmt yuv420p -s $normalisation -r $normalisation -i pipe: \
			-an -target dvd -f mpeg1video -maxrate 8000 -ildct -ilme -aspect 16:9 -y "$M2V"
			mplex -v 0 -f 8 -o "$VOB" "$M2V" "$AC3" &
			dvdauthor -o "$file" --chapters=`$get_chapters -f $frame_rate -x $smil_file` "$VOB"
			dvdauthor -o "$file" -T
			rm -f "$VOB"
			;;
	esac
	rm -f "$M2V" "$AC3"
}

[ "$1" = "--usage" -o "$1" = "" ] && usage $@ || execute $@
