/*
* page_magick.h -- Image Magick Integration
* Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software Foundation,
* Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _PAGE_MAGICK_H
#define _PAGE_MAGICK_H

#include "image_create.h"
#include "image_filters.h"
#include "image_transitions.h"
#include "audio_filters.h"
#include "audio_transitions.h"
#include "kino_common.h"
#include "page.h"
#include "oss.h"

/** Simple class wrapping for the shared object functions.
*/

class Plugin
{
private:
	void *ptr;

public:
	bool Open( char *file );
	void Close( );
	void *Find( char *symbol );
	char *GetError( );
};

/** Holds the complete collection of shared objects.
*/

class PluginCollection
{
private:
	vector < Plugin * > collection;

public:
	PluginCollection( );
	~PluginCollection( );
	void Initialise( char *directory );
	void RegisterPlugin( char *filename );
	unsigned int Count();
	Plugin *Get( unsigned int index );
};

/** Image Create Repository with load from plugin functionality.
*/

class PluginImageCreateRepository : public GDKImageCreateRepository
{
public:
	void InstallPlugins( Plugin * );
};

/** Image Filter Repository with load from plugin functionality.
*/

class PluginImageFilterRepository : public GDKImageFilterRepository
{
public:
	void InstallPlugins( Plugin * );
};

/** Image Transition Repository with load from plugin functionality.
*/

class PluginImageTransitionRepository : public GDKImageTransitionRepository
{
public:
	void InstallPlugins( Plugin * );
};

/** Audio Filter Repository with load from plugin functionality.
*/

class PluginAudioFilterRepository : public GDKAudioFilterRepository
{
public:
	void InstallPlugins( Plugin * );
};

/** Audio Transition Repository with load from plugin functionality.
*/

class PluginAudioTransitionRepository : public GDKAudioTransitionRepository
{
public:
	void InstallPlugins( Plugin * );
};

/** Magick page class
*/

class PageMagick : public Page
{
public:
	PageMagick( KinoCommon *common );
	virtual ~PageMagick();

	void newFile();
	void start();
	gulong activate();
	void clean();
	void selectScene( int );

	void StartPreview();
	void StartRender();
	void Stop();
	void StopPreview();
	void UpdateProgress( gfloat );
	void RefreshStatus( bool with_fx_notify = false );

	GDKImageCreate *GetImageCreate() const;
	GDKImageFilter *GetImageFilter() const;
	GDKImageTransition *GetImageTransition() const;
	GDKAudioFilter *GetAudioFilter() const;
	GDKAudioTransition *GetAudioTransition() const;

	void LoadSplash();

	void ChangePage( int page = -1 );
	gboolean processKeyboard( GdkEventKey *event );
	gboolean processCommand( char *cmd );
	void timeFormatChanged();
	std::string getHelpPage()
	{
		return "fx.html";
	}

	GtkWidget *window;
private:
	// Imported
	KinoCommon *common;

	int last_page;
	bool rendering;
	bool previewing;
	GtkProgressBar *progressBar;
	char status[ 10240 ];

	// Filters and Transitions
	PluginImageCreateRepository image_creators;
	PluginImageFilterRepository image_filters;
	PluginImageTransitionRepository image_transitions;
	PluginAudioFilterRepository audio_filters;
	PluginAudioTransitionRepository audio_transitions;

	// audio structures
	dv_oss_t *audio_device;
	dv_audio_t dv_audio;
	bool audio_device_avail;
	gint audio_sampling_rate;
	void PlayAudio( int16_t *buffers[], int, int, bool );

	// Video structures
	void ShowImage( GtkWidget *area, uint8_t *pixels, int, int );

	PluginCollection plugins;

	string last_fx_file;
};

#endif
