#include <string.h>
#include <time.h>

#include <gtk/gtk.h>

#include "kptimeentry.h"

#include "../kipina-i18n.h"
#include "../kputil.h"


static void     kp_time_entry_class_init     (KPTimeEntryClass *klass);
static void     kp_time_entry_finalize       (GObject *object);
static void     kp_time_entry_init           (KPTimeEntry *dialog);

static GObjectClass *parent_class;


GType
kp_time_entry_get_type (void)
{
  static GType kp_time_entry_type = 0;

  if (kp_time_entry_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPTimeEntryClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_time_entry_class_init,
      NULL,
      NULL,
      sizeof (KPTimeEntry),
      0,
      (GInstanceInitFunc) kp_time_entry_init,
      NULL,
    };

    kp_time_entry_type = g_type_register_static (GTK_TYPE_SPIN_BUTTON,
                                                "KPTimeEntry",
                                                &our_info, 0);
  }
  return kp_time_entry_type;
}


static gboolean
kp_time_entry_input_cb (GtkSpinButton *button, gdouble *arg)
{
  *arg = (gdouble) kp_duration_str_to_ms (gtk_entry_get_text (&button->entry));
  return TRUE;
}


static gboolean
kp_time_entry_output_cb (GtkSpinButton *button)
{
  gchar *str = kp_date_mseconds_to_std_string ((guint) button->adjustment->value);
  gtk_entry_set_text (GTK_ENTRY (button), str);
  g_free (str);

  return TRUE;
}


static void
kp_time_entry_class_init (KPTimeEntryClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->finalize = kp_time_entry_finalize;
  parent_class = g_type_class_peek_parent (klass);
}


static void
kp_time_entry_init (KPTimeEntry *dentry)
{
  GtkObject *adj = 
    gtk_adjustment_new (0.0,                        /* Start */
                        0.0,                        /* Min */
                        1000.0 * 60.0 * 60.0 * 999, /* Max */
                        1000.0 * 60.0 *  1.0,       /* Increment */
                        0.0,                        /* Page increment */
                        0.0);                       /* Page size */
  
  gtk_spin_button_configure (GTK_SPIN_BUTTON (dentry), 
                             GTK_ADJUSTMENT (adj), 1.0 * 1000.0, 0);

  g_signal_connect (G_OBJECT (dentry), "output",
                    G_CALLBACK (kp_time_entry_output_cb), dentry);
  g_signal_connect (G_OBJECT (dentry), "input",
                    G_CALLBACK (kp_time_entry_input_cb), dentry);
}


static void
kp_time_entry_finalize (GObject *object)
{
  KPTimeEntry *dialog;

  g_return_if_fail (KP_IS_DATE_ENTRY (object));
  dialog = KP_TIME_ENTRY (object);
  g_return_if_fail (dialog->private_data != NULL);

  g_free (dialog->private_data);
  
  G_OBJECT_CLASS (parent_class)->finalize (object);
}


/**
 * kp_time_entry_new:
 *
 * Create an instance of #KPTimeEntry.
 *
 * Returns: A #KPTimeEntry
 */
GtkWidget *
kp_time_entry_new (void)
{
  return g_object_new (KP_TYPE_DATE_ENTRY, NULL);
}


guint
kp_time_entry_get_time (KPTimeEntry *entry)
{
  return (guint) GTK_SPIN_BUTTON (entry)->adjustment->value;
}
  

void
kp_time_entry_set_time (KPTimeEntry *entry, KPTime *time)
{
} 



