/***************************************************************************
  *   FPreferences.cpp                                                      *
  *   Copyright (C) 2003-2005 by Stephan Gans                               *
  *   mephistoki@users.sourceforge.net                                      *
  *   Created: Mon Nov 24 20:05:26 2003                                     *
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  *   This program is distributed in the hope that it will be useful,       *
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
  *   GNU General Public License for more details.                          *
  *                                                                         *
  *   You should have received a copy of the GNU General Public License     *
  *   along with this program; if not, write to the                         *
  *   Free Software Foundation, Inc.,                                       *
  *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
  ***************************************************************************/

#include "FPreferences.h"
#include "dirops.h"

#include <kprocess.h>
#include <kiconloader.h>
#include <klocale.h>

Formpref::Formpref(QWidget *parent)
     : KDialogBase(IconList, i18n("Preferences"),
                   Ok | Cancel , Ok, parent, 0, false)
{
   m_actDirectory = QDir::currentDirPath();
   QDir::setCurrent( QDir::homeDirPath() );

   KIconLoader *loader = KGlobal::iconLoader();

   m_config = new KSimpleConfig("kisorc");
   m_config->setGroup("Preferences");

   initGeneralPage(loader);
   initApplicationsPage(loader);
   initBackground();

   connect( this, SIGNAL( okClicked() ), this, SLOT( Newprefs() ) );
   connect( this, SIGNAL( cancelClicked() ), this, SLOT( cancel() ) );
}

void Formpref::initGeneralPage(KIconLoader* loader)
{
   m_GeneralPage = addVBoxPage((const QString&) i18n("General"),
                               (const QString&) i18n("General Settings"),
                               loader->loadIcon("configure", 
KIcon::NoGroup, 32));

   initDriveBox();
   initSizeBox();
   initStyleselect();
   initHiddenFilesCheck();
   initSoundsButtonCheck();
}

void Formpref::initApplicationsPage(KIconLoader* loader)
{
   m_HelperPage = addVBoxPage((const QString&) i18n("Applications"),
                              (const QString&) i18n("Helping Applications"),
                              loader->loadIcon("gear", KIcon::NoGroup, 32));

   initBurnbox();
   initHexbox();
}

void Formpref::initDriveBox()
{
   QHBox* Driveselect = new QHBox(m_GeneralPage);
   QLabel* Labeldrives = new QLabel( Driveselect, "Labeldrives" );
   Labeldrives->setText( i18n( "Standart drive:" ) );

   QString readde = m_config->readEntry("Read", 0);

   m_Drivebox = new QComboBox( FALSE, Driveselect, "Drivebox" );
   m_Drivebox->clear();
   m_Drivebox->insertStringList( getDeviceList() );

   for (uint8_t i = 0; i<m_Drivebox->count(); i++)
   {
     if (m_Drivebox->text(i) == readde)
       m_Drivebox->setCurrentItem(i);
   }
}

void Formpref::initSizeBox()
{
   QHBox* Sizeselect = new QHBox(m_GeneralPage);
   QLabel* Labelsize = new QLabel( Sizeselect, "Labelsize" );
   Labelsize->setText( i18n( "CD Size:" ) );

   m_SizeBox = new QComboBox( FALSE, Sizeselect, "SizeBox" );
   m_SizeBox->clear();
   m_SizeBox->insertItem( "650 MB"  );
   m_SizeBox->insertItem( "700 MB"  );
   m_SizeBox->insertItem( "800 MB"  );
   m_SizeBox->insertItem( "4472 MB (DVD)" );
   m_SizeBox->insertItem( "8500 MB (DL-DVD)" );
   m_SizeBox->setCurrentItem( m_config->readNumEntry("CD-Size", 0) );
}

void Formpref::initStyleselect()
{
   QHBox *Styleselect = new QHBox(m_GeneralPage);
   QLabel *Labelstyle = new QLabel(Styleselect, "Labelstyle");
   Labelstyle->setText( i18n( "KIso Skin:" ) );

   m_Stylequester = new KURLRequester( Styleselect, "Stylequester" );
   m_Stylequester->setURL( m_config->readEntry("Skin", 0) );
}

void Formpref::initHiddenFilesCheck()
{
   m_Hiddencheck = new QCheckBox(m_GeneralPage, "Hiddencheck");
   m_Hiddencheck->setText( i18n( "Show hidden files" ) );
   m_Hiddencheck->setChecked ( m_config->readBoolEntry("Hidden", false) );
}

void Formpref::initSoundsButtonCheck()
{
   m_Buttoncheck = new QCheckBox( m_GeneralPage, "Buttoncheck" );
   m_Buttoncheck->setText( i18n( "Button sounds" ) );
   m_Buttoncheck->setChecked ( m_config->readBoolEntry("Sounds", false) );
}

void Formpref::initBurnbox()
{
   QHBox *Burningapp = new QHBox(m_HelperPage);

   QLabel *Labelburn = new QLabel( Burningapp, "Labelburn" );
   Labelburn->setText( i18n( "Burnprogram:" ) );

   m_Burnbox = new QComboBox( FALSE, Burningapp, "Burnbox" );
   m_Burnbox->clear();
   if (Proofforapp("k3b")) m_Burnbox->insertItem( "K3b" );
   if (Proofforapp("cdbakeoven")) m_Burnbox->insertItem( "CD Bake Oven" );
   m_Burnbox->setCurrentItem( m_config->readNumEntry("Burning", 0) );
}

void Formpref::initHexbox()
{
   QHBox *Hexapp = new QHBox(m_HelperPage);

   QLabel* Labelhex = new QLabel( Hexapp, "Labelhex" );
   Labelhex->setText( i18n( "Hexeditor:" ) );

   m_Hexbox = new QComboBox( FALSE, Hexapp, "Hexbox" );
   m_Hexbox->clear();
   if (Proofforapp("khexedit")) m_Hexbox->insertItem( "KHexEdit" );
   if (Proofforapp("ghex2")) m_Hexbox->insertItem( "GHex2" );
   m_Hexbox->setCurrentItem( m_config->readNumEntry("Hexeditor", 0) );
}

void Formpref::initBackground()
{
   QString skinname = m_config->readEntry("Skin", 0);
   if (skinname)
   {
     KSimpleConfig skin(skinname);
     skin.setGroup("Backgrounds");
     QString SkinBase = QFileInfo(skinname).dirPath() + "/";
     if (skin.readEntry("general", 0)!="")
       setPaletteBackgroundPixmap( 
QPixmap(SkinBase+skin.readEntry("general", 0)) );
   }
}

bool Formpref::Proofforapp(QString Appname)
{
   bool installed=true;
   KProcess* proof = new KShellProcess ();
   (*proof)<< "which" << Appname;
   proof->start(KShellProcess::Block, KShellProcess::Stdout);
   int status = proof->exitStatus();
   if(status)
     installed=false;
   return installed;
}

void Formpref::Newprefs()
{
   KSimpleConfig conf("kisorc");
   conf.setGroup("Preferences");
   conf.writeEntry("Read", m_Drivebox->currentText());
   conf.writeEntry("Burning", m_Burnbox->currentText());
   conf.writeEntry("Hexeditor", m_Hexbox->currentText());
   conf.writeEntry("Hidden", m_Hiddencheck->isChecked());
   conf.writeEntry("Sounds", m_Buttoncheck->isChecked());
   conf.writeEntry("CD-Size", m_SizeBox->currentItem());
   conf.writeEntry("Skin", m_Stylequester->url());
   QDir::setCurrent(m_actDirectory);
   accept();
}

void Formpref::cancel()
{
   QDir::setCurrent(m_actDirectory);
   reject();
}

#include "FPreferences.moc"
