package kissme.vm.loaders;

import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;

import java.io.InputStream;
import java.io.File;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;

public class JarClassLoader {

  private static HashMap jarfilesMap = new HashMap();

  /* we use this Object to cache the fact that it doesn't exist */
  private static final Object NO_JAR_FILE = new Object();

  private static String fileSeparator;

  public static byte[] getClassData(String className, String loaderPath) 
  {
    JarFile jf = getJarFile(loaderPath);
    if (jf == null) {
      return null;
    }
    
    JarEntry je = (JarEntry) jf.getEntry(className + ".class");
    if (je != null) {
      int length = (int) je.getSize();
      byte[] buffer = new byte[length];
      try {
	InputStream is = jf.getInputStream(je);
	int haveread = 0;
	while (haveread < length) {
	  int res = is.read(buffer, haveread, (length - haveread));
	  if (res == -1) {
	    return null;
	  }
	  haveread += res;
	}
      } catch (ZipException ze) {
	return null;
      }
      catch (IOException ioe) {
	return null;
      }
      return buffer;
    }
    else {
      return null;
    }
  }


  private static JarFile getJarFile(String loaderPath) 
  {
    Object hashResult = null;
    JarFile jf = null;

    if ((hashResult = jarfilesMap.get(loaderPath)) == null) {
      /* we haven't cached this zip file yet */
      try {
	jf = new JarFile(new File(loaderPath));
	jarfilesMap.put(loaderPath, jf);
	return jf;
      } 
      catch (IOException ex) {
	jarfilesMap.put(loaderPath, NO_JAR_FILE);
	return null;
      }
    }
    else {
      if (hashResult == NO_JAR_FILE) {
	return null;
      }
      else {
	return (JarFile) hashResult;
      }
    }
  }

  public static String getResourceUrl(String name, String loaderPath)
  {
    JarFile jf = getJarFile(loaderPath);
    if (jf == null) {
      return null;
    }

    JarEntry je = (JarEntry) jf.getEntry(name);
    if (je == null) {
      return null;
    }
    if (fileSeparator == null) {
      fileSeparator = System.getProperty("file.separator");
    }
    return "jar:file:" + loaderPath + "!" + name;
  }

}
