package hitme;

/**
 * The base class for HitMe test cases.
 **/
public abstract class HitMeTest 
{
  protected HitMeLogger m_logger;

  /**
   * If <b>predicate</b> is not true, log error messge <b>msg</b>.
   * Use this method when you don't want to trust the JVM's String
   * concatenation implementation; i.e. StringBuffer.append(*) 
   * and the like.
   */
  public void check(boolean predicate, String msg) {
    m_logger.check(predicate, msg);
  }

  /** Check that two booleans are the same **/
  public void expect(boolean a1, boolean a2) {
    m_logger.check(a1 == a2, "expected " + a1 + ", got " + a2);
  }
  
  /** Check that two booleans are the same with a message **/
  public void expect(boolean a1, boolean a2, String desc) {
    m_logger.check(a1 == a2, desc + ": expected " + a1 + ", got " + a2);
  }
  
  /** Check that two ints are the same **/
  public void expect(int a1, int a2) {
    m_logger.check(a1 == a2, "expected " + a1 + ", got " + a2);
  }
  
  /** Check that two ints are the same with a message **/
  public void expect(int a1, int a2, String desc) {
    m_logger.check(a1 == a2, desc + ": expected " + a1 + ", got " + a2);
  }
  
  /** Check that two longs are the same **/
  public void expect(long a1, long a2) {
    m_logger.check(a1 == a2, "expected " + a1 + ", got " + a2);
  }
  
  /** Check that two longs are the same with a message **/
  public void expect(long a1, long a2, String desc) {
    m_logger.check(a1 == a2, desc + ": expected " + a1 + ", got " + a2);
  }
  
  /** Check that two doubles are the same **/
  public void expect(double a1, double a2) {
    m_logger.check(a1 == a2, "expected " + a1 + ", got " + a2);
  }
  
  /** Check that two doubles are the same with a message **/
  public void expect(double a1, double a2, String desc) {
    m_logger.check(a1 == a2, desc + ": expected " + a1 + ", got " + a2);
  }
  
  /**
   * This method is called by the harness to invoke a test.  It
   * sets the test case's logger and deals with the error flag.
   * @param logger the logger to use for diagnistics, etcetera.
   * @return true if the test case succeeds, false if it fails.
   * @exception Exception is propagated from the test case.
   **/
  public boolean runTest(HitMeLogger logger) throws Exception {
    m_logger = logger;
    m_logger.clear();
    test();
    return m_logger.isOk();
  }

  /**
   * Execute the test case.  The test outcome is signalled by calls
   * to the logger; e.g. direcly or via the helper methods.
   * @exception a test case may throw any Exception
   **/
  public abstract void test() throws Exception;

  /**
   * @return a short description of the testcase for the test summary
   **/
  public abstract String describe();

  /** 
   * Helper method: calls 'errln(msg)' on the test's logger.
   **/
  public void errln(String msg) {
    m_logger.errln(msg);
  }

  /** 
   * Helper method: calls 'err(ex)' on the test's logger.
   **/
  public void err(Throwable ex) {
    m_logger.err(ex);
  }

  /** 
   * Helper method: calls 'err(msg)' on the test's logger.
   **/
  public void err(String msg) {
    m_logger.err(msg);
  }

  /** 
   * Helper method: calls 'logln(msg)' on the test's logger.
   **/
  public void logln(String msg) {
    m_logger.logln(msg);
  }

  /** 
   * Helper method: calls 'log(ex)' on the test's logger.
   **/
  public void log(Throwable ex) {
    m_logger.log(ex);
  }

  /** 
   * Helper method: calls 'log(msg)' on the test's logger.
   **/
  public void log(String msg) {
    m_logger.log(msg);
  }

}
