package hitme.basic.lang;

/**
 * Testing Object.wait and notify methods, and Thread.interrupt interaction
 */
public class WaitNotify extends hitme.HitMeTest implements Runnable
{
  private String syncObject = "Synch";
  private int state = 0;

  public String describe() {
    return "Object wait/notify test";
  }

  public void run() { 
    synchronized (syncObject) {
      try {
	state = 1;
	syncObject.wait();
	state = 2;
	syncObject.wait();
        state = 3;
	syncObject.wait(1000);
	state = 4;
      }
      catch (InterruptedException ex) {
	err(ex);
      }
      try {
        syncObject.wait();
      }
      catch (InterruptedException ex) {
	state = 5;
      }
    }
  }
  
  public void test() {
    try {
      Thread t = new Thread(this);
      t.start();
      Thread.sleep(1000);
      check(state == 1, "thread has not reached the 'wait'");
      synchronized (syncObject) {
	syncObject.notify();
      }
      Thread.sleep(1000);
      check(state == 2, "thread has not returned from the untimed 'wait'");
      synchronized (syncObject) {
	syncObject.notify();
      }
      Thread.sleep(2000);
      check(state == 4, "thread has not returned from the timed 'wait'");
      t.interrupt();
      Thread.sleep(2000);
      check(state == 5, "thread 'wait' was not interrupted");
    }
    catch (InterruptedException ex) {
      err(ex);
    }
  }
}
