#include "config.h"

#include <stdlib.h>
#include <stdio.h>

#include "vm/jni.h"
#include "vm/jni_data.h"
#include "vm/interp.h"
#include "vm/interp_methods.h"
#include "vm/classloader_tuple.h"
#include "vm/newobject.h"
#include "vm/thread.h"
#include "lib/indigenous/java.lang/Class_Reflection.h"
#include "lib/indigenous/java.lang/VMSecurityManager.h"


jobjectArray java_lang_VMSecurityManager_getClassContext(JNIEnv *env, 
							 jclass obj)
{
  tStackFrame* f;
  int numFrames = 0;
  int numInitialFrames = 0;
  int securityManagerPos = -1;
  int i, j;
  jarray res;
  jclass classClass = (*env)->FindClass(env, "java/lang/Class");
  tClassLoaderTuple* securityManagerType = 
    CLASSFILE_FindOrLoad(env, "java/lang/SecurityManager", NULL);
  
  assert(classClass != NULL && securityManagerType != NULL);

  numInitialFrames = 
    THREADINFO_countInitialStackFramesFromNode(THREAD_FindThread());

  // First, count the frames, and find the position of the sessionmanager
  // frame relative to the stack base.
  for (i = 0; i < numInitialFrames; i++) {
    int numInInitialFrame = 0;
    int securityManagerInThisInitialFrame = 0;
    tStackFrame* topFrame = 
      THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), i);
    f = topFrame;
    while (f != NULL) {
      if (f->pstCurrMethod->pstClass == securityManagerType) {
	securityManagerPos = numFrames;
	securityManagerInThisInitialFrame = 1;
      }
      numFrames++;
      numInInitialFrame++;
      f = f->pstChildFrame;
    }
    if (securityManagerPos >= 0 && !securityManagerInThisInitialFrame) {
      securityManagerPos += numInInitialFrame;
    }
  }

  // Allocate the result array
  res = (*env)->NewObjectArray(env, securityManagerPos, classClass, NULL);
  (*env)->NewLocalRef(env, (jobject) res);

  // Copy the context class objects into the result array
  for (i = 0, j = securityManagerPos - 1;
       i < numInitialFrames && j >= 0; 
       i++) {
    tStackFrame* topFrame = 
      THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), i);
    f = topFrame;
    while (f != NULL && j >= 0) {
      jclass contextClass =
	CLASSLOADER_TUPLE_GetClassObject(env, f->pstCurrMethod->pstClass);
      (*env)->SetObjectArrayElement(env, res, j--, contextClass);
      f = f->pstChildFrame;
    }
  } 
  
  return res;
}             


/** Get the current ClassLoader--the one nearest to the
 ** top of the stack.
 ** @return the current ClassLoader.
 **/

//static native ClassLoader currentClassLoader();
jobject java_lang_VMSecurityManager_currentClassLoader(JNIEnv *env, jclass obj)
{
  tClassLoaderTuple* privilegedActionClass =
    CLASSFILE_FindOrLoad(env, "java/security/PrivilegedAction", NULL);
  jobject result;
  int numInitialFrames;
  int i;

  assert(privilegedActionClass);
  numInitialFrames = 
    THREADINFO_countInitialStackFramesFromNode(THREAD_FindThread());
  
  for (i = numInitialFrames; i >= 0; i--) {
    tStackFrame* f = 
      THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), i);
    int haveResult = 0;

    while (f != NULL) {
      if (INTERP_CheckCast(env, privilegedActionClass, 
			   f->pstCurrMethod->pstClass)) {
	haveResult = 1;
	result = NULL;
      }
      else if (f->pstCurrMethod->pstClass->classLoader) {
	haveResult = 1;
	result = f->pstCurrMethod->pstClass->classLoader;
      }
      f = f->pstChildFrame;
    }
    if (haveResult) {
      return result;
    }
  } 
  return NULL;
}
