/*
 * @doc MODULE
 * @module garbage.h |
 *
 * Function prototypes for memory management and garbage collection stuff.
 * The GARBAGE_INITIALHEAPSIZE definition is here, along with the
 * GARBAGE_MINFREESIZE definition. Other definitions here that are used
 * externally are GARBAGE_OBJECT, GARBAGE_ARRAY that
 * are used in the interpreter for marking objects and arrays for
 * identification during garbage collection.
 *
 */

#ifndef __GARBAGE_H__
#define __GARBAGE_H__

#include "vm/interp.h"
#include "vm/stdtypes.h"
#include "vm/jni.h"

void GARBAGE_LOCK();
void GARBAGE_UNLOCK();


extern int32 GARBAGE_INITIALHEAPSIZE;
extern int32 GARBAGE_INITIALHANDLENUM;

#include "vm/garbage_defs.h"

#ifdef PERSIST

extern int32 GARBAGE_NUMDEFFRAMES;
extern int32 GARBAGE_NUMDEFREACH;


/* flag for flagging objects reachable from preferably kept frames */
/*#define GARBAGE_PREFKEEP  524288L*/
/* flag for flagging objects reachable from definitely (?) kept frames */
#define GARBAGE_DEFKEEP  1048576L

#endif

tOBREF GARBAGE_Malloc(int32 i32Size 
		      /* @parm Size of memory required in bytes */, 
		      tAllocatorHeap* pstHeap);
tObject* GARBAGE_MallocObj(int32 i32Size 
			   /* @parm Size of memory required in bytes */, 
			   tAllocatorHeap* pstHeap);
void GARBAGE_MallocOldHandle(int32 i32Size, tOBREF hHandle);
tOBREF GARBAGE_AllocHandle(void);

void GARBAGE_RegisterFinalizable(tOBREF obj, tAllocatorHeap* pstHeap);
				       
// void GARBAGE_gc(tAllocatorHeap* pstHeap);
void GARBAGE_Finish(tAllocatorHeap* pstHeap);
void GARBAGE_WriteEverything(void);
void doCheck();
int GARBAGE_InHeap(JNIEnv* env, tOBREF obj);
int GARBAGE_InSpecifiedHeap(tAllocatorHeap* pstHeap, tOBREF obj);
tAllocatorHeap* GARBAGE_Init();
void GARBAGE_lock_and_gc(JNIEnv* env, tAllocatorHeap* pstHeap);
int GARBAGE_getNumTotalWords(JNIEnv* env, tAllocatorHeap* pstHeap);
int GARBAGE_getNumFreeWords(JNIEnv* env, tAllocatorHeap* pstHeap);

void RecursivelyMark
(
  tOBREF o,        /* @parm The handle of the item to mark */
  int    iBFCheck, /* @parm Whether or not to perform the bitfield check */
  int32  i32Flag,
  tOBREF parent
);

void MarkThreadStacks();
void MarkCStacks();
void DumpHeapBlocks();

/* local definitions and types */ //This is actually local, but we put it in the header so that we can have function prototypes

#ifndef __theapblock__
#define __theapblock__
/*
 * @doc TYPE
 * @struct
 * This structure holds information used internally to handle the heap. Each
 * will hold information about a specific heap block (in the general case
 * there will be a linked list of heap blocks).
 *
 */

struct theapblock
  {
    int32                i32HeapSize;   /* @field The amount of memory in this
                                                    heap block in int32s */
    int32*               pi32Heap;      /* @field Pointer to actual memory for
                                                    this heap block */
    int32                i32BFSize;     /* @field Size of bit field in int32s */
    int32*               pi32BitField;  /* @field Pointer to bit field */
    int32*               pi32FirstFree; /* @field Pointer to first free space in
                                                    this heap block */
    int32                i32NumHandles;  /* @field Number of handles used in this
                                                     block */
    tOBREF               hFirstFreeHandle; /* @field Pointer to the first free
                                                     handle in the handle area */
#ifndef HANDLEBLOCKS
    int32*               pi32HandleEnd;    /* @field Pointer to end of handle area */
#endif
    struct theapblock* pstNext;         /* @field Pointer to next heap block */
  };

typedef struct theapblock tHeapBlock;
#endif


void GARBAGE_VerifyObject(tHeapBlock* pstTempHB, tObject* obj) ;

void GARBAGE_unlock_and_gc();

#endif
