#ifdef not_def
{
  {
    {
#endif

    case i2l:
      {
	int oldint;
        optop++;
	
	oldint = (int) *(optop - 1);
	*((long long*) (optop - 1)) = (long long) oldint;
        break;
      }
      
    case i2f:
      {
	*((float*) (optop)) = *((int32*) (optop));
	break;
      }
      
    case i2d:
      {
	optop++;
	*((double*) (optop - 1)) = (double) *((int*) (optop - 1));
	break;
      }
      
    case l2i:
      {
        optop--;
	*optop = (int) ( *((long long*) (optop)));
        break;
      }

    case l2f:
      {
	optop--;
	*((float*) (optop)) = *((long long*) (optop));
        break;
      }
      
    case l2d:
      {
	*((double*) (optop - 1)) = *((long long*) (optop -1));
	break;
      }
      
    case f2i:
      {
	float fTemp = *((float*) optop);

	if (isJavaFloatNaN(fTemp)) {
	  *optop = 0;
	}
	else if (fTemp >= (float) 0x7fffffff) {
	  *optop = 0x7fffffff;
	}
	else if (fTemp <= ((float) ((int) 0x80000000))) {
	  *optop = 0x80000000;
	}
	else if (fTemp >= 0.0f) {
	  *optop = (int) fTemp;
	}
	else {
	  *optop = -((int) -fTemp);
	}
#ifdef DEBUG_FLOAT
        eprintf("f2i %f -> %i\n", fTemp, *optop);
#endif
	break;
      }
      
    case f2l:
      {
	float fTemp = *((float*) optop);

	optop++;
	if (isJavaFloatNaN(fTemp)) {
	  *((long long*) (optop - 1)) = 0;
	}
	else if (fTemp >= (float) 0x7fffffffffffffff) {
	  *((long long*) (optop - 1)) = 0x7fffffffffffffff;
	}
	else if (fTemp <= ((float) ((int) 0x8000000000000000))) {
	  *((long long*) (optop - 1)) = 0x8000000000000000;
	}
	else if (fTemp >= 0.0f) {
	  *((long long*) (optop - 1)) = (long long) fTemp;
	}
	else {
	  *((long long*) (optop - 1)) = -((long long) -fTemp);
	}
#ifdef DEBUG_FLOAT
        eprintf("f2l %f -> %li\n", fTemp, *((long long*) (optop - 1)));
#endif
	break;
      }
      
    case f2d:
      {
	optop++;
	*((double*) (optop - 1)) = (double) *((float*) (optop - 1));
	break;
      }
      
    case d2i:
      {
	double dTemp = *((double*) (optop - 1));

	optop--;
	if (isJavaDoubleNaN(dTemp)) {
	  *((int32*) (optop)) = 0;
	}
	else if (dTemp >= (double) 0x7fffffff) {
	  *((int32*) (optop)) = 0x7fffffff;
	}
	else if (dTemp <= ((double) ((int32) 0x80000000))) {
	  *((int32*) (optop)) = 0x80000000;
	}
	else if (dTemp >= 0.0) {
	  *((int32*) (optop)) = (int32) dTemp;
	}
	else {
	  *((int32*) (optop)) = -((int32) -dTemp);
	}
#ifdef DEBUG_FLOAT
        eprintf("d2i %lf -> %i\n", dTemp, *optop);
#endif
	break;
      }
      
    case d2l:
      {
	double dTemp = *((double*) (optop - 1));

	if (isJavaDoubleNaN(dTemp)) {
	  *((long long*) (optop - 1)) = 0;
	}
	else if (dTemp >= (double) 0x7fffffffffffffff) {
	  *((long long*) (optop - 1)) = 0x7fffffffffffffff;
	}
	else if (dTemp <= ((double) ((long long) 0x8000000000000000))) {
	  *((long long*) (optop - 1)) = 0x8000000000000000;
	}
	else if (dTemp >= 0.0) {
	  *((long long*) (optop - 1)) = (long long) dTemp;
	}
	else {
	  *((long long*) (optop - 1)) = -((long long) -dTemp);
	}
#ifdef DEBUG_FLOAT
        eprintf("d2l %lf -> %li\n", dTemp, *((long long*) (optop - 1)));
#endif
	break;
      }
      
    case d2f:
      {
	optop--;
	*((float*) (optop)) = *((double*) (optop));
	break;
      }
      
    case int2byte:   /* these don't seem to need any computation */
      {
	int8 temp;
	temp = *optop;
	*optop = temp;
	break;
      }
      
    case int2char:
      {
	//we lose the sign
	*optop = *optop & 0xffff;
	break;
      }
      
    case int2short:
      {
	int16 tmp = *((int32*) (optop));
	//We have to preserve the sign silly!!!
	*optop = tmp;
	break;
      }
      
