/*
 * @doc MODULE
 * @module jutils.h |
 *
 * This file contains declarations for use in jutils.c.
 *
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <stdlib.h>

/*
 * @doc TYPE
 * @struct UTILS_stack |
 * This structure is used for implementing the stack.
 *
 */

typedef struct
{
	int  count;       /* @field Number of elements in stack */
  int  max_len;     /* @field Maximum number of elements */
  int  delta_len;   /* @field Amount to increase size by when stack is full */
	int* elements;    /* @field Memory for elements */
} UTILS_stack;

/* prototypes */
#ifdef OLDMEMTRACKING
void* UTILS_mmalloc(size_t size);
void UTILS_mfree(void*);
void UTILS_PrintMemUsed(void);
#endif

UTILS_stack *UTILS_Stack_New(int initsize, int deltasize);
void UTILS_Stack_Destroy(UTILS_stack *);
int UTILS_Stack_Pop(UTILS_stack *);
int UTILS_Stack_PopTop(UTILS_stack *);
void UTILS_Stack_Push(UTILS_stack *, int);

#endif
