/*
 * Copyright (C) 2003, Stephen Crawley
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "vm/kni.h"
#include "vm/jni_data.h"


static jint KNI_GetKNIVersion(JNIEnv* env)
{
  return KNI_VERSION_1_0;
}


static tAllocatorHeap* KNI_GetHeap(JNIEnv* env)
{
  return JNI_getCurrentHeap();
}


static void KNI_EnterGCPoint(JNIEnv* env)
{
  GARBAGE_EnterGCPoint(JNI_getCurrentHeap());
}


static void KNI_EnterGCRegion(JNIEnv* env)
{
  GARBAGE_EnterGCRegion(JNI_getCurrentHeap());
}


static void KNI_ExitGCRegion(JNIEnv* env)
{
  GARBAGE_ExitGCRegion(JNI_getCurrentHeap());
}


#ifdef PERSIST
static tOBREF KNI_SwizzleObjectField (JNIEnv* env, jobject obj, jfieldID field)
{
  /* only do something if it's a reference field */
  switch (field->uidFieldSig[0]) {
  case 'L':
  case '[':
    if (ISPID(DEREF(obj)->pi32Vars[field->u16Offset])) {
      DEREF(obj)->pi32Vars[field->u16Offset] = 
	(int32) RPOT_FaultObject(DEREF(obj)->pi32Vars[field->u16Offset]);
    }
    return (tOBREF) DEREF(obj)->pi32Vars[field->u16Offset];

  default:
      return NULL;
  }
}


static tOBREF KNI_SwizzleArrayElement (JNIEnv* env, jobjectArray array,
				       jint element)
{
  /* only do something if it's a reference array */
  switch (ADEREF(array)->enType) {
  case T_ARRAY:
  case T_OBJECT:
    if (ISPID(((PID*) ADEREF(array)->pvElements)[element])) {
      ((PID*) ADEREF(array)->pvElements)[element] = 
	(int32) RPOT_FaultObject(((PID*) ADEREF(array)->pvElements)[element]);
    }
    return (tOBREF) ((PID*) ADEREF(array)->pvElements)[element];
    
  default:
    return NULL;
  }
}


static void KNI_MarkUpdated (JNIEnv* env, jobject obj)
{
  DEREF(obj)->i32Flags |= PERSIST_Dirty;
}


static void KNI_MarkRefsUpdated (JNIEnv* env, jobject obj)
{
  DEREF(obj)->i32Flags |= PERSIST_RefsDirty;
}
#endif

static const struct KissmeNativeInterface functionTable =
{
  NULL, 
  NULL,
  NULL,

  KNI_GetKNIVersion,
  KNI_GetHeap,

#ifdef PERSIST
  KNI_SwizzleObjectField,  
  KNI_SwizzleArrayElement,
  KNI_MarkUpdated,
  KNI_MarkRefsUpdated,
#else
  NULL, 
  NULL,
  NULL,
  NULL,
#endif

  KNI_EnterGCPoint,
  KNI_EnterGCRegion,
  KNI_ExitGCRegion
};

/* Get the default KissmeNativeInterface object */
KNIApi *KNI_getKNIApiPtr()
{
  return (KNIApi *)(&functionTable);
}


