/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * thread.h
 *
 */

#ifndef __THREAD_H__
#define __THREAD_H__

#ifdef KISSME_LINUX_USER
#include <pthread.h>
#endif

#include "vm/jni.h"
#include "vm/jni_data.h"

#include "vm/interp/methodstacks.h"
#include "vm/llist.h"
#include "vm/wrappers.h"
#include "vm/garbage/public_methods.h"


void java_lang_Thread_yield(JNIEnv* env, jobject obj);
void java_lang_Thread_sleep(JNIEnv* env, jobject obj, 
			    jlong millis, jint nanos);
void java_lang_Thread_start(JNIEnv* env, jobject obj);
jboolean java_lang_Thread_isAlive(JNIEnv* env, jobject obj);
void java_lang_Thread_nativeSuspend(JNIEnv* env, jobject obj);
void java_lang_Thread_nativeResume(JNIEnv* env, jobject obj);
void java_lang_Thread_nativeSetPriority(JNIEnv* env, jobject obj, 
					jint newPriority);
jint java_lang_Thread_countStackFrames(JNIEnv* env, jobject obj);

//void java_lang_Thread__createJNIData(JNIEnv* env, jobject obj);

void java_lang_Thread_nativeInit(JNIEnv* env, jobject obj, jlong size);

jobject java_lang_Thread_currentThread(JNIEnv* env, jobject obj);
jboolean java_lang_Thread_holdsLock(JNIEnv* env, jobject obj, jobject target);
jboolean java_lang_Thread_interrupted(JNIEnv* env, jobject obj);
jboolean java_lang_Thread_isInterrupted(JNIEnv* env, jobject obj);
void java_lang_Thread_nativeInterrupt(JNIEnv* env, jobject obj);
void java_lang_Thread_nativeStop(JNIEnv* env, jobject obj, jobject throwable);

int THREAD_unlockThreadList();
tMutex* THREAD_GetThreadListMutex();


#ifndef __thread_node__
#define __thread_node__
typedef struct tthreadnode
{
  pthread_t           pthread; 
  threadId_t          threadId;
  jobject	      object;        // A reference to the java/lang/Thread obj
  struct tthreadnode* next;          // Next pointer
  
  tList*	      pstInitialFrames;
  
  void*	              stackBottom;   // The place where the stack starts. 
                                     // From here to stackTop is the C stack.
  void*	              stackTop;      // The place where the stack ends. 
  int		      isInterrupted; // Flag indicating whether this thread
                                     // has been interrupted
  int		      isDaemon;      // Flag indicating whether this is a 
                                     // daemon thread.  (Cached value only)
  int		      state;         // Indicates the thread's state; see
                                     // THREAD_STATE_* below.

  // for sablevm locking, we need a contention bit, a contention lock and 
  // all of waiting thread,object,cond tuples, and a waitNotify list
  
#ifdef SABLE_LOCKS
  int32               i32ContentionBit;
  tMutex*             mutContentionLock;
  tList*              pstWaitList;
#endif

  tOBREF              waitObject;    // If this thread is waiting for a
                                     // java.lang.Object.notify(), this
                                     // is the object.
} tThreadNode;

// These values are used in the 'state' field of tThreadNode
#define THREAD_STATE_RUNNABLE           1
#define THREAD_STATE_SLEEPING           2
#define THREAD_STATE_SLEEP_INTERRUPTED  3
#define THREAD_STATE_WAITING            4
#define THREAD_STATE_WAIT_INTERRUPTED   5
#define THREAD_STATE_TERMINATED         6
#define THREAD_STATE_IO	                7


// This struct represents a thread waiting to aquire an object lock.  
// Instances are queued on the 'pstWaitList' of the tThreadNode for the
// thread that currently  holds the object's lock.
typedef struct twaitstruct 
{
  pthread_t           threadId;  // the waiting thread
  tOBREF              object;    // the object it wants to lock
  tCondVariable*      cond;      // the condition the thread is waiting on
} tWaitStruct;


typedef struct tthreadargs
{
  tStackFrame*        newFrame;
  tStackFrame*        cleanupFrame; //unused in kissme
  tOBREF              threadObject;
  tClassLoaderTuple*  pstMainClass; //unused in kissme
  void*               returnStackBottom;
  JNIEnv*             env;
  tAllocatorHeap*     pstOrigHeap; //unused in kissme
} tThreadArgs;


#ifdef EVICTIONS
typedef struct tthreadstackelem
{
  tOBREF              hThread;
  tStackFrame*        pstTopFrame;
  struct tthreadstackelem* pstNext;
} tThreadStackElem;
#endif
#endif


tThreadNode* THREAD_lockAndGetThreadList();
tThreadNode* THREAD_FindThread();
pthread_mutex_t* THREAD_getThreadListMutex();
tThreadNode* THREAD_getThreadList();
void THREAD_setThreadList(tThreadNode* nlist);
void THREAD_Init();
int THREAD_GetNumberThreads(tAllocatorHeap* pstHeap);

#ifdef DEBUG
void THREAD_dumpThreads();
#endif 

#define THREAD_ID_BITS 15
#define NOS_THREAD_IDS (1 << THREAD_ID_BITS)
#define THREAD_ID_MAX (NOS_THREAD_IDS - 1)
#define NO_THREAD_ID ((threadId_t) 0)

tJNIData* THREAD_createJNIData(JNIEnv* env, jobject obj);
void THREAD_destroyJNIData(tJNIData* ptr);

threadId_t THREAD_newThreadId(pthread_t hint);
void THREAD_freeThreadId(threadId_t threadId);
void THREAD_initThreadIds();
threadId_t THREAD_getThreadId(pthread_t pthread);

#include "vm/threadinfo.h"

#endif

