# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class BoardListView < KDE::ListView
  slots 'load_board_list()'
  slots 'show_board(QListViewItem*)'
  slots 'context_menu(QListViewItem*,const QPoint&,int)'

  POPUP_COPY_URL = 0
  POPUP_COPY_TITLE_AND_URL = 1

  COLUMN_TITLE = 0
  COLUMN_URL = 1

  def initialize(parent)
    super(parent)

    setRootIsDecorated(true)
    setSorting(-1)
    addColumn("board name")

    connect(self, SIGNAL("clicked(QListViewItem*)"),
            self, SLOT("show_board(QListViewItem*)"))
    connect(self, SIGNAL("contextMenuRequested(QListViewItem*,const QPoint&,int)"),
            self, SLOT("context_menu(QListViewItem*,const QPoint&,int)"))

    str = nil
    begin
      str = Downloader.load_menu_list
    rescue
      str = ""
    end
    parse_board_list(str)
  end

  BOARD_REGEXP = /<A HREF=([^ ]*).*>(.*)<\/A>/
  GROUP_REGEXP = /<BR><BR><B>(.*)<\/B><BR>/

  def load_board_list
    str = Downloader.download_menu_list
    parse_board_list(str)
  end

  def parse_board_list(str)
    group_list = []
    current_group = nil
    str.each {|line|
      if GROUP_REGEXP.match(line)
        group_name = Regexp.last_match[1]

        current_group = BoardGroup.new(group_name)
        group_list.push(current_group)
      elsif BOARD_REGEXP.match(line)
        board_url = Regexp.last_match[1]
        board_name = Regexp.last_match[2]

        next unless Util.board_url?(board_url)
        board = Board.new(board_url, board_name)
        BoardManager.instance.register(board_url, board_name)
        current_group.push(board) if current_group
      end
    }
    group_list.delete_if {|group|
      group.list.empty?
    }

    clear

    group_list.reverse.each {|group|
      item = KDE::ListViewItem.new(self, group.name)
      group.list.reverse.each {|board|
        KDE::ListViewItem.new(item, board.title, board.url)
      }
    }

    BoardManager.instance.register("http://jbbs.livedoor.jp/computer/18420/", "Kita板")
    KDE::ListViewItem.new(self, "Kita板", "http://jbbs.livedoor.jp/computer/18420/")
  end

  def show_board(item)
    return if item == nil

    board_url = item.text(COLUMN_URL)

    ViewMediator.show_board(board_url)
  end

  def context_menu(item, pos, col)
    return unless item

    board_url = item.text(COLUMN_URL)
    board_title = item.text(COLUMN_TITLE)

    popup = KDE::PopupMenu.new
    popup.insertItem("Copy URL", POPUP_COPY_URL)
    popup.insertItem("Copy title and URL", POPUP_COPY_TITLE_AND_URL)

    clipboard = Qt::Application.clipboard
    case popup.exec(pos)
    when POPUP_COPY_URL
      clipboard.setText(board_url, Qt::Clipboard::Clipboard)
      clipboard.setText(board_url, Qt::Clipboard::Selection)
    when POPUP_COPY_TITLE_AND_URL
      cliptext = board_title + "\n" + board_url
      clipboard.setText(cliptext, Qt::Clipboard::Clipboard)
      clipboard.setText(cliptext, Qt::Clipboard::Selection)
    end
  end
end
