#!/usr/bin/ruby

# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$KCODE = 'UTF8'

require 'Korundum'
require 'open-uri'
require 'kconv'

require 'board.rb'
require 'thread_info.rb'
require 'download.rb'
require 'dat.rb'
require 'util.rb'
require 'const.rb'
require 'threadview.rb'
require 'mainwindow.rb'
require 'threadlistview.rb'
require 'boardlistview.rb'
require 'writedialog.rb'
require 'threadtabwidget.rb'
require 'accountpage.rb'
require 'preferencedialog.rb'
require 'config.rb'
require 'account.rb'
require 'htmlpart.rb'
require 'boardtabwidget.rb'

class ViewMediator
  def ViewMediator.thread_tab_widget=(tab_widget)
    @@thread_tab_widget = tab_widget
  end

  def ViewMediator.board_tab_widget=(tab_widget)
    @@board_tab_widget = tab_widget
  end

  def ViewMediator.show_board(url)
    @@board_tab_widget.show_board(url)
  end

  def ViewMediator.show_thread(url)
    @@thread_tab_widget.show_thread(url)
  end

  def ViewMediator.copy
    @@thread_tab_widget.copy
  end

  def ViewMediator.set_url(url)
    $main_window.url_line.setText(url)
  end

  def self.remove_thread_view(view)
    @@thread_tab_widget.remove_view(view)
  end

  def self.remove_thread_list_view(view)
    @@board_tab_widget.remove_view(view)
  end
end

about = KDE::AboutData.new("kita", "Kita - 2ch client for KDE", Const::Version)
KDE::CmdLineArgs.init(ARGV, about)
$app = KDE::UniqueApplication.new

$main_window = MainWindow.new(0)
$main_window.resize(800, 600)
$main_window.show

$app.exec
