# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class ThreadInfo
  attr_reader :dat_url, :title, :res_num, :open_time, :speed
  attr_reader :read_num

  def initialize(dat_url, title, res_num, open_time, speed)
    @dat_url = dat_url
    @title = title
    @res_num = res_num
    @open_time = open_time
    @speed = ((speed * 100).truncate) / 100.0

    load_index
  end

  def load_index
    dat_file_name = Util.dat_url_to_dat_file_name(@dat_url)
    dir = Util.dat_url_to_dat_dir_path(@dat_url)
    config = KDE::Config.new(dir + "/" + dat_file_name + ".idx")

    @read_num = config.group("").readEntry("ResNum", 0)
  end
end
