/***************************************************************************
                          kbpickicondlg.h  -  description
                             -------------------
    begin                : Sat Jul 21 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBPICKICONDLG_H
#define KBPICKICONDLG_H

#include <kdialogbase.h>

class QWidget;
class QStringList;
class QPixmap;
class KListBox;

/**A dialog to pick an icon for a keyboard layout
  *@author Leonid Zeitlin
  */

class KBPickIconDlg : public KDialogBase  {
   Q_OBJECT
public: 
	KBPickIconDlg(const QString &currentPath, const QPixmap &currentPixmap,
	  QWidget *parent=0, const char *name=0);
	~KBPickIconDlg();
  /** Get the path name of the selected icon. Returns empty string if no icon selected */
  QString getIconPath();
  /** No descriptions */
  const QPixmap* getIcon();
private: // Private attributes
  /**  */
  //QStringList m_pathnames;
  //QString m_iconpath;
  //KIconView *m_iconview;
  KListBox *lbIcons;
  //QLabel *lblIcon;
  //QRadioButton *rbFlags;
  //QRadioButton *rbBrowse;
  void loadCountryFlags();
  void loadGkbCountryFlags();
  void showCurrentPath(const QString &currentPath, const QPixmap &currentPixmap);
private slots: // Private slots
  /** Browse for an arbitrary icon file */
  void slotBrowseForIcon();
  /** Respond to user selecting a flag in the icon view */
  //void slotFlagSelected(QIconViewItem *item);
};

#endif
