/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KLAMSCAN_H_
#define _KLAMSCAN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <dcopklamscan.h>


class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QListView;
class QListViewItem;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class CollectionSetup;
class QToolButton;
class QHBoxLayout;

namespace KlamAV
{
    class TabWidget;
    class PageViewer;
}
/**
 * This class serves as the main window for Klamscan.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Klamscan  : public QWidget, virtual public DCOPKlamscan
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Klamscan(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Klamscan();

    /**
     * Use this method to load whatever file/URL you have
     */
    
    void  setDirName(QString);
    bool isMultiScan();
protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:

private:
    void setupAccel();
    void setupActions();

private:

signals:

public slots:
    void scanURLs(const QString &urls);
private slots:
    void slotScan();
    void slotAdvOptions();
    void slotSchedule();

    void slotStopScanning();
    void slotStartAgain();
    void slotRemoveTab();
    void slotManageButtons(QWidget *current);
private:
    void setDefaults();
    QString pruneSelectedDirs();
    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo, *check_combo;
    QCheckBox *recursive_box;
    QListView *resultview;
    QPushButton *search_button, *cancel_button;
    QLabel *status_label, *status2_label,*matches_label,*matches2_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    bool errorsEncountered;
    QPopupMenu* menu;
    QPushButton* adv_options;
    QString urlsToScan;
    QString prevdir;
    QStringList listOfUrlsToScan;
    bool multi_recursive;
    KlamAV::TabWidget* tabBrowser;
    CollectionSetup* setup;
    QToolButton *m_tabsClose;
    QToolButton* play;
    QToolButton* stop;
    QHBoxLayout* controls;
};

#endif // _KLAMSCAN_H_
