/*
 * Basic course
 */
#include <stdlib.h>
#include <string.h>

#include "support.h"
#include "main.h"
#include "keyboard.h"
#include "tutor.h"
#include "basic.h"

/**********************************************************************
 * Variables
 */
extern GtkWidget *window_tutor_;

struct
{
  gint lesson;
  gunichar char_set[6 * 14];
  gint char_set_size;
} basic;

/*******************************************************************************
 * Interface functions
 */
gint
basic_get_lesson ()
{
  return (basic.lesson);
}

void
basic_set_lesson (gint lesson)
{
  basic.lesson = lesson;
  if (window_tutor_ != NULL)
    g_key_file_set_integer (main_preferences_get (), "tutor", "basic_lesson", lesson);
}

gunichar *
basic_get_char_set ()
{
  return (basic.char_set);
}

/*******************************************************************************
 * Initialize basic vars
 */
void
basic_init ()
{
  /*
   * Retrieve the last lesson where the student had stopped.
   */
  tutor_set_query (QUERY_INTRO);
  if (basic.lesson != 0)
    {
      basic_init_char_set ();
      tutor_process_touch ('\0');
      return;
    }

  if (g_key_file_has_key (main_preferences_get (), "tutor", "basic_lesson", NULL))
    {
      basic.lesson = g_key_file_get_integer (main_preferences_get (), "tutor", "basic_lesson", NULL);
      basic_init_char_set ();
      tutor_process_touch ('\0');
    }
  else
    {
      basic_set_lesson (1);
      basic_init_char_set ();
      tutor_update ();
      gtk_widget_hide (lookup_widget (window_tutor_, "button_revert_lesson"));
      gtk_widget_hide (lookup_widget (window_tutor_, "button_reset_lesson"));
    }
}

/**********************************************************************
 * Read the characters to be used with the current basic.lesson
 */
gint
basic_init_char_set ()
{
  gint i, j, k;
  gchar line_str[16];
  gchar *lesson_file;
  FILE *fh;

  /*
   * Open the lesson file
   */
  lesson_file =
    g_strconcat (main_get_data_path (), "basic_lessons.txt", NULL);
  fh = (FILE*) g_fopen (lesson_file, "r");
  g_free (lesson_file);
  if (!fh)
    g_error ("couldn't find the basic lessons' file.");

  /*
   * Search the lesson
   */
  for (i = 1; i < basic.lesson; i++)
    for (j = 0; j < 11; j++)
      if (!(fgets (line_str, 16, fh)))
	break;

  /*
   * Pass heading line
   */
  if (!(fgets (line_str, 16, fh)))
    {
      basic.char_set[0] = L'\0';
      fclose (fh);
      return (1);
    }

  /*
   * Get chars, lower set
   */
  for (k = 0, i = 0; i < 4; i++)
    {
      if (!(fgets (line_str, 16, fh)))
	{
	  basic.char_set[0] = L'\0';
	  fclose (fh);
	  return (-1);
	}
      for (j = 0; j < 14; j++)
	{
	  if (line_str[j] == '1'
	      && g_unichar_isgraph (keyb_get_lochars (i, j)))
	    basic.char_set[k++] = g_unichar_tolower (keyb_get_lochars (i, j));
	}
    }

  /*
   * Pass blank line
   */
  if (!(fgets (line_str, 16, fh)))
    {
      basic.char_set[0] = L'\0';
      fclose (fh);
      return (-1);
    }

  /*
   * Get chars, upper set
   */
  for (i = 0; i < 4; i++)
    {
      if (!(fgets (line_str, 16, fh)))
	{
	  basic.char_set[0] = L'\0';
	  fclose (fh);
	  return (-1);
	}
      for (j = 0; j < 14; j++)
	if (line_str[j] == '1' && g_unichar_isgraph (keyb_get_upchars (i, j)))
	  basic.char_set[k++] = g_unichar_tolower (keyb_get_upchars (i, j));
    }
  fclose (fh);

  basic.char_set[k] = L'\0';
  basic.char_set_size = k;
  return (0);
}

/**********************************************************************
 * Put the lesson's characters at the main screen
 */
#define N_LINES 8
void
basic_draw_lesson ()
{
  gint i, j, k, len;
  gint remain, idx, rnd;
  gchar *ut8_tmp;
  gunichar sentence[9 * 6 + 4];
  gunichar char_pool[N_LINES * 9 * 5];
  GtkWidget *wg;
  GtkTextBuffer *buf;

  wg = lookup_widget (window_tutor_, "text_tutor");
  buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (wg));

  /*
   * Fill in the character pool
   */
  if ((len = basic.char_set_size) < 2)
    {
      g_warning ("no character set for this lesson.");
      return;
    }


  for (k = 0; k < (N_LINES * 9 * 5 - len); k += len)
    {
      memmove (char_pool + k, basic.char_set, len * sizeof (gunichar));
    }
  remain = (N_LINES * 9 * 5) % len;
  remain = remain ? remain : len;
  memmove (char_pool + k, basic.char_set, remain * sizeof (gunichar));

  /*
   * Draw the lines as sentences
   */
  sentence[9 * 6] = L'\n';
  sentence[9 * 6 + 1] = L'\0';
  sentence[9 * 6 + 2] = L'\0';
  len = N_LINES * 9 * 5;
  for (i = 0; i < N_LINES; i++)
    {				/* lines (sentences) */
      idx = 0;
      for (j = 0; j < 9; j++)
	{			/* words */
	  for (k = 0; k < 5; k++)
	    {			/* letters */
	      rnd = rand () % len;
	      sentence[idx++] = char_pool[rnd];
	      char_pool[rnd] = char_pool[--len];
	    }
	  sentence[idx++] = (j < 8) ? L' ' : UPSYM;
	}
      ut8_tmp = g_ucs4_to_utf8 (sentence, -1, NULL, NULL, NULL);
      gtk_text_buffer_insert_at_cursor (buf, ut8_tmp, -1);
      g_free (ut8_tmp);
    }
}

/**********************************************************************
 * Put on the screen the final comments
 */
void
basic_comment (gdouble accuracy)
{
  gchar str[1000];
  GtkLabel *wg_label;
  GtkWidget *wg;
  GtkTextBuffer *buf;

  /*
   * Comments
   */
  if (accuracy < 95.0)
    g_sprintf (str,
	       _(" You did not succeed.\n"
		 " The accuracy must be above 95 %%.\n" " Try again!\n"));
  else
    {
      basic_set_lesson (basic.lesson + 1);
      if (basic.lesson > 43)
	{
	  basic_set_lesson (1);
	  wg_label =
	    GTK_LABEL (lookup_widget (window_tutor_, "label_heading"));
	  gtk_label_set_text (wg_label,
			      _("Positions of keys seems to be learned!"));
	  g_sprintf (str,
		     _(" Congratulations!\n"
		       " You have accomplished the entire basic course.\n"
		       " Go to the next type of exercise: adaptability.\n"
		       " There you will practice mainly the accuracy.\n"));
	}
      else
	g_sprintf (str,
		   _(" All right, now you got it!\n"
		     " Go to the next lesson.\n"));

     basic_init_char_set ();
    }

  wg = lookup_widget (window_tutor_, "text_tutor");
  buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (wg));
  gtk_text_buffer_insert_at_cursor (buf, str, strlen (str));
}
