/**************************************************************************/
/*  Klavaro - a flexible touch typing tutor                               */
/*  Copyright (C) 2005 - 2007  Felipe Castro                              */
/*                                                                        */
/*  This program is free software, licensed under the terms of the GNU    */
/*  General Public License as published by the Free Software Foundation,  */
/*  which is also included in this package, in a file named "COPYING".    */
/**************************************************************************/

/*
 * Special colors
 */
#ifndef TUTOR_H
# define TUTOR_H
# define TUTOR_GRAY_BLUE "#E8E8EA"
# define TUTOR_RED "#FFA090"
# define TUTOR_GREEN "#80F0A0"
# define TUTOR_YELLOW_GREEN "#C0C070"
# define TUTOR_CREAM "#F8F8F4"
# define TUTOR_BLACK "#000000"
# define TUTOR_WHITE "#FFFFF8"

typedef enum
{
	TT_BASIC,
	TT_ADAPT,
	TT_VELO,
	TT_FLUID
} TutorType;

typedef enum
{
	QUERY_INTRO,
	QUERY_START,
	QUERY_PROCESS_TOUCHS,
	QUERY_END
} TutorQuery;

/*
 * Interface functions
 */
TutorType tutor_get_type (void);

gchar *tutor_get_type_name (void);

TutorQuery tutor_get_query (void);

void tutor_set_query (TutorQuery);

void tutor_init_timers (void);

/*
 * Auxiliar functions
 */
void tutor_init (TutorType tutor_type);

void tutor_update (void);

void tutor_update_intro (void);

void tutor_update_start (void);

void tutor_process_touch (gunichar user_chr);

gboolean tutor_eval_forward (gunichar chr);

gboolean tutor_eval_forward_backward (gunichar chr);

void tutor_calc_stats (void);

void tutor_draw_paragraph (gchar * text);

void tutor_message (gchar * mesg);

void tutor_beep (void);

void tutor_load_list_other (gchar * file_name_end, GtkListStore * list);

#endif
