
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMotifStyle.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMotifStyle>
#include <QApplication>
#include <QChildEvent>
#include <QEvent>
#include <QFontMetrics>
#include <QIcon>
#include <QObject>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QSize>
#include <QStyle>
#include <QStyleHintReturn>
#include <QStyleOption>
#include <QStyleOptionComplex>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMotifStyle

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMotifStyle::staticMetaObject);
}


// void QMotifStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)


static void _init_f_drawComplexControl_c9027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawComplexControl_c9027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->drawComplexControl (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, arg3, arg4);
}


// void QMotifStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawControl_c8285 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawControl_c8285 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ControlElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->drawControl (qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(arg1).cref(), arg2, arg3, arg4);
}


// void QMotifStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawPrimitive_c8501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPrimitive_c8501 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  QPainter *arg3 = gsi::arg_reader<QPainter * >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->drawPrimitive (qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(arg1).cref(), arg2, arg3, arg4);
}


// bool QMotifStyle::event(QEvent *)


static void _init_f_event_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_event_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QMotifStyle *)cls)->event (arg1));
}


// int QMotifStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)


static void _init_f_pixelMetric_c6642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_pixelMetric_c6642 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<int > ((int)((QMotifStyle *)cls)->pixelMetric (qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(arg1).cref(), arg2, arg3));
}


// void QMotifStyle::polish(QPalette &)


static void _init_f_polish_1418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1418 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = gsi::arg_reader<QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->polish (arg1);
}


// void QMotifStyle::polish(QWidget *)


static void _init_f_polish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->polish (arg1);
}


// void QMotifStyle::polish(QApplication *)


static void _init_f_polish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_polish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->polish (arg1);
}


// void QMotifStyle::setUseHighlightColors(bool)


static void _init_f_setUseHighlightColors_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUseHighlightColors_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->setUseHighlightColors (arg1);
}


// QSize QMotifStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)


static void _init_f_sizeFromContents_c8477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_f_sizeFromContents_c8477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ContentsType>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QSize &arg3 = gsi::arg_reader<const QSize & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QSize > ((QSize)((QMotifStyle *)cls)->sizeFromContents (qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(arg1).cref(), arg2, arg3, arg4));
}


// QPalette QMotifStyle::standardPalette()


static void _init_f_standardPalette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_standardPalette_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QMotifStyle *)cls)->standardPalette ());
}


// QPixmap QMotifStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)


static void _init_f_standardPixmap_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_f_standardPixmap_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QPixmap > ((QPixmap)((QMotifStyle *)cls)->standardPixmap (qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(arg1).cref(), arg2, arg3));
}


// int QMotifStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)


static void _init_f_styleHint_c8615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData", true, "0");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_f_styleHint_c8615 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StyleHint>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  QStyleHintReturn *arg4 = args ? gsi::arg_reader<QStyleHintReturn * >() (args, heap) : gsi::arg_maker<QStyleHintReturn * >() (0, heap);
  ret.write<int > ((int)((QMotifStyle *)cls)->styleHint (qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(arg1).cref(), arg2, arg3, arg4));
}


// QRect QMotifStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)


static void _init_f_subControlRect_c9798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_subControlRect_c9798 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & >() (args, heap);
  const QStyleOptionComplex *arg2 = gsi::arg_reader<const QStyleOptionComplex * >() (args, heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubControl>::target_type & >() (args, heap);
  const QWidget *arg4 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QRect > ((QRect)((QMotifStyle *)cls)->subControlRect (qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(arg1).cref(), arg2, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(arg3).cref(), arg4));
}


// QRect QMotifStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)


static void _init_f_subElementRect_c6528 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_subElementRect_c6528 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::SubElement>::target_type & >() (args, heap);
  const QStyleOption *arg2 = gsi::arg_reader<const QStyleOption * >() (args, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QRect > ((QRect)((QMotifStyle *)cls)->subElementRect (qt_gsi::QtToCppAdaptor<QStyle::SubElement>(arg1).cref(), arg2, arg3));
}


// void QMotifStyle::unpolish(QWidget *)


static void _init_f_unpolish_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->unpolish (arg1);
}


// void QMotifStyle::unpolish(QApplication *)


static void _init_f_unpolish_1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_unpolish_1843 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = gsi::arg_reader<QApplication * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle *)cls)->unpolish (arg1);
}


// bool QMotifStyle::useHighlightColors()


static void _init_f_useHighlightColors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_useHighlightColors_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMotifStyle *)cls)->useHighlightColors ());
}


// static QString QMotifStyle::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QMotifStyle::tr (arg1, arg2));
}


// static QString QMotifStyle::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QMotifStyle::tr (arg1, arg2, arg3));
}


// static QString QMotifStyle::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QMotifStyle::trUtf8 (arg1, arg2));
}


// static QString QMotifStyle::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QMotifStyle::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMotifStyle () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Method void QMotifStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QCommonStyle::drawComplexControl", true, &_init_f_drawComplexControl_c9027, &_call_f_drawComplexControl_c9027);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Method void QMotifStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QCommonStyle::drawControl", true, &_init_f_drawControl_c8285, &_call_f_drawControl_c8285);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Method void QMotifStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QCommonStyle::drawPrimitive", true, &_init_f_drawPrimitive_c8501, &_call_f_drawPrimitive_c8501);
  methods += new qt_gsi::GenericMethod ("event", "@brief Method bool QMotifStyle::event(QEvent *)\nThis is a reimplementation of QObject::event", false, &_init_f_event_1217, &_call_f_event_1217);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Method int QMotifStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis is a reimplementation of QCommonStyle::pixelMetric", true, &_init_f_pixelMetric_c6642, &_call_f_pixelMetric_c6642);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QMotifStyle::polish(QPalette &)\nThis is a reimplementation of QCommonStyle::polish", false, &_init_f_polish_1418, &_call_f_polish_1418);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QMotifStyle::polish(QWidget *)\nThis is a reimplementation of QCommonStyle::polish", false, &_init_f_polish_1315, &_call_f_polish_1315);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Method void QMotifStyle::polish(QApplication *)\nThis is a reimplementation of QCommonStyle::polish", false, &_init_f_polish_1843, &_call_f_polish_1843);
  methods += new qt_gsi::GenericMethod ("setUseHighlightColors|useHighlightColors=", "@brief Method void QMotifStyle::setUseHighlightColors(bool)\n", false, &_init_f_setUseHighlightColors_864, &_call_f_setUseHighlightColors_864);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Method QSize QMotifStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)\nThis is a reimplementation of QCommonStyle::sizeFromContents", true, &_init_f_sizeFromContents_c8477, &_call_f_sizeFromContents_c8477);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@brief Method QPalette QMotifStyle::standardPalette()\nThis is a reimplementation of QStyle::standardPalette", true, &_init_f_standardPalette_c0, &_call_f_standardPalette_c0);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Method QPixmap QMotifStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QCommonStyle::standardPixmap", true, &_init_f_standardPixmap_c6956, &_call_f_standardPixmap_c6956);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Method int QMotifStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\nThis is a reimplementation of QCommonStyle::styleHint", true, &_init_f_styleHint_c8615, &_call_f_styleHint_c8615);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Method QRect QMotifStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\nThis is a reimplementation of QCommonStyle::subControlRect", true, &_init_f_subControlRect_c9798, &_call_f_subControlRect_c9798);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Method QRect QMotifStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)\nThis is a reimplementation of QCommonStyle::subElementRect", true, &_init_f_subElementRect_c6528, &_call_f_subElementRect_c6528);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QMotifStyle::unpolish(QWidget *)\nThis is a reimplementation of QCommonStyle::unpolish", false, &_init_f_unpolish_1315, &_call_f_unpolish_1315);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Method void QMotifStyle::unpolish(QApplication *)\nThis is a reimplementation of QCommonStyle::unpolish", false, &_init_f_unpolish_1843, &_call_f_unpolish_1843);
  methods += new qt_gsi::GenericMethod (":useHighlightColors", "@brief Method bool QMotifStyle::useHighlightColors()\n", true, &_init_f_useHighlightColors_c0, &_call_f_useHighlightColors_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMotifStyle::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMotifStyle::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMotifStyle::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMotifStyle::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMotifStyle::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QCommonStyle> &qtdecl_QCommonStyle ();

qt_gsi::QtNativeClass<QMotifStyle> decl_QMotifStyle (qtdecl_QCommonStyle (), "QtGui", "QMotifStyle_Native",
  methods_QMotifStyle (),
  "@hide\n@alias QMotifStyle");

GSI_QTGUI_PUBLIC gsi::Class<QMotifStyle> &qtdecl_QMotifStyle () { return decl_QMotifStyle; }

}


class QMotifStyle_Adaptor : public QMotifStyle, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMotifStyle_Adaptor();

  //  [adaptor ctor] QMotifStyle::QMotifStyle(bool useHighlightCols)
  QMotifStyle_Adaptor() : QMotifStyle()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMotifStyle::QMotifStyle(bool useHighlightCols)
  QMotifStyle_Adaptor(bool useHighlightCols) : QMotifStyle(useHighlightCols)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QMotifStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)
  int fp_QMotifStyle_layoutSpacingImplementation_c11697 (const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control1, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control2, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QStyleOption *option, const QWidget *widget) const {
    return QMotifStyle::layoutSpacingImplementation(qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), option, widget);
  }

  //  [expose] int QMotifStyle::receivers(const char *signal)
  int fp_QMotifStyle_receivers_c1731 (const char *signal) const {
    return QMotifStyle::receivers(signal);
  }

  //  [expose] QObject *QMotifStyle::sender()
  QObject * fp_QMotifStyle_sender_c0 () const {
    return QMotifStyle::sender();
  }

  //  [expose] QIcon QMotifStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)
  QIcon fp_QMotifStyle_standardIconImplementation_c6956 (const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & standardIcon, const QStyleOption *opt, const QWidget *widget) const {
    return QMotifStyle::standardIconImplementation(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(standardIcon).cref(), opt, widget);
  }

  //  [adaptor impl] void QMotifStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)
  void cbs_drawComplexControl_c9027_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    QMotifStyle::drawComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, p, w);
  }

  virtual void drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawComplexControl_c9027_1.can_issue()) {
      cb_drawComplexControl_c9027_1.issue<QMotifStyle_Adaptor, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, QPainter *, const QWidget *>(&QMotifStyle_Adaptor::cbs_drawComplexControl_c9027_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, p, w);
    } else {
      QMotifStyle::drawComplexControl(cc, opt, p, w);
    }
  }

  //  [adaptor impl] void QMotifStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawControl_c8285_1(const qt_gsi::Converter<QStyle::ControlElement>::target_type & element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QMotifStyle::drawControl(qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(element).cref(), opt, p, w);
  }

  virtual void drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawControl_c8285_1.can_issue()) {
      cb_drawControl_c8285_1.issue<QMotifStyle_Adaptor, const qt_gsi::Converter<QStyle::ControlElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QMotifStyle_Adaptor::cbs_drawControl_c8285_1, qt_gsi::CppToQtAdaptor<QStyle::ControlElement>(element), opt, p, w);
    } else {
      QMotifStyle::drawControl(element, opt, p, w);
    }
  }

  //  [adaptor impl] void QMotifStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)
  void cbs_drawItemPixmap_c5678_0(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    QMotifStyle::drawItemPixmap(painter, rect, alignment, pixmap);
  }

  virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    if (cb_drawItemPixmap_c5678_0.can_issue()) {
      cb_drawItemPixmap_c5678_0.issue<QMotifStyle_Adaptor, QPainter *, const QRect &, int, const QPixmap &>(&QMotifStyle_Adaptor::cbs_drawItemPixmap_c5678_0, painter, rect, alignment, pixmap);
    } else {
      QMotifStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
  }

  //  [adaptor impl] void QMotifStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)
  void cbs_drawItemText_c10604_1(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, const qt_gsi::Converter<QPalette::ColorRole>::target_type & textRole) const
  {
    QMotifStyle::drawItemText(painter, rect, flags, pal, enabled, text, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(textRole).cref());
  }

  virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole) const
  {
    if (cb_drawItemText_c10604_1.can_issue()) {
      cb_drawItemText_c10604_1.issue<QMotifStyle_Adaptor, QPainter *, const QRect &, int, const QPalette &, bool, const QString &, const qt_gsi::Converter<QPalette::ColorRole>::target_type &>(&QMotifStyle_Adaptor::cbs_drawItemText_c10604_1, painter, rect, flags, pal, enabled, text, qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(textRole));
    } else {
      QMotifStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
  }

  //  [adaptor impl] void QMotifStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawPrimitive_c8501_1(const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QMotifStyle::drawPrimitive(qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(pe).cref(), opt, p, w);
  }

  virtual void drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawPrimitive_c8501_1.can_issue()) {
      cb_drawPrimitive_c8501_1.issue<QMotifStyle_Adaptor, const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QMotifStyle_Adaptor::cbs_drawPrimitive_c8501_1, qt_gsi::CppToQtAdaptor<QStyle::PrimitiveElement>(pe), opt, p, w);
    } else {
      QMotifStyle::drawPrimitive(pe, opt, p, w);
    }
  }

  //  [adaptor impl] bool QMotifStyle::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QMotifStyle::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMotifStyle_Adaptor, bool, QEvent *>(&QMotifStyle_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QMotifStyle::event(arg1);
    }
  }

  //  [adaptor impl] QPixmap QMotifStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)
  QPixmap cbs_generatedIconPixmap_c5776_0(const qt_gsi::Converter<QIcon::Mode>::target_type & iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    return QMotifStyle::generatedIconPixmap(qt_gsi::QtToCppAdaptor<QIcon::Mode>(iconMode).cref(), pixmap, opt);
  }

  virtual QPixmap generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    if (cb_generatedIconPixmap_c5776_0.can_issue()) {
      return cb_generatedIconPixmap_c5776_0.issue<QMotifStyle_Adaptor, QPixmap, const qt_gsi::Converter<QIcon::Mode>::target_type &, const QPixmap &, const QStyleOption *>(&QMotifStyle_Adaptor::cbs_generatedIconPixmap_c5776_0, qt_gsi::CppToQtAdaptor<QIcon::Mode>(iconMode), pixmap, opt);
    } else {
      return QMotifStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }
  }

  //  [adaptor impl] QStyle::SubControl QMotifStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)
  qt_gsi::Converter<QStyle::SubControl>::target_type cbs_hitTestComplexControl_c9517_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    return qt_gsi::CppToQtAdaptor<QStyle::SubControl>(QMotifStyle::hitTestComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, pt, w));
  }

  virtual QStyle::SubControl hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    if (cb_hitTestComplexControl_c9517_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStyle::SubControl>(cb_hitTestComplexControl_c9517_1.issue<QMotifStyle_Adaptor, qt_gsi::Converter<QStyle::SubControl>::target_type, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const QPoint &, const QWidget *>(&QMotifStyle_Adaptor::cbs_hitTestComplexControl_c9517_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, pt, w)).cref();
    } else {
      return QMotifStyle::hitTestComplexControl(cc, opt, pt, w);
    }
  }

  //  [adaptor impl] QRect QMotifStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)
  QRect cbs_itemPixmapRect_c4360_0(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    return QMotifStyle::itemPixmapRect(r, flags, pixmap);
  }

  virtual QRect itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    if (cb_itemPixmapRect_c4360_0.can_issue()) {
      return cb_itemPixmapRect_c4360_0.issue<QMotifStyle_Adaptor, QRect, const QRect &, int, const QPixmap &>(&QMotifStyle_Adaptor::cbs_itemPixmapRect_c4360_0, r, flags, pixmap);
    } else {
      return QMotifStyle::itemPixmapRect(r, flags, pixmap);
    }
  }

  //  [adaptor impl] QRect QMotifStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)
  QRect cbs_itemTextRect_c7544_0(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    return QMotifStyle::itemTextRect(fm, r, flags, enabled, text);
  }

  virtual QRect itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    if (cb_itemTextRect_c7544_0.can_issue()) {
      return cb_itemTextRect_c7544_0.issue<QMotifStyle_Adaptor, QRect, const QFontMetrics &, const QRect &, int, bool, const QString &>(&QMotifStyle_Adaptor::cbs_itemTextRect_c7544_0, fm, r, flags, enabled, text);
    } else {
      return QMotifStyle::itemTextRect(fm, r, flags, enabled, text);
    }
  }

  //  [adaptor impl] int QMotifStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)
  int cbs_pixelMetric_c6642_2(const qt_gsi::Converter<QStyle::PixelMetric>::target_type & metric, const QStyleOption *option, const QWidget *widget) const
  {
    return QMotifStyle::pixelMetric(qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(metric).cref(), option, widget);
  }

  virtual int pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_pixelMetric_c6642_2.can_issue()) {
      return cb_pixelMetric_c6642_2.issue<QMotifStyle_Adaptor, int, const qt_gsi::Converter<QStyle::PixelMetric>::target_type &, const QStyleOption *, const QWidget *>(&QMotifStyle_Adaptor::cbs_pixelMetric_c6642_2, qt_gsi::CppToQtAdaptor<QStyle::PixelMetric>(metric), option, widget);
    } else {
      return QMotifStyle::pixelMetric(metric, option, widget);
    }
  }

  //  [adaptor impl] void QMotifStyle::polish(QPalette &)
  void cbs_polish_1418_0(QPalette &arg1)
  {
    QMotifStyle::polish(arg1);
  }

  virtual void polish(QPalette &arg1)
  {
    if (cb_polish_1418_0.can_issue()) {
      cb_polish_1418_0.issue<QMotifStyle_Adaptor, QPalette &>(&QMotifStyle_Adaptor::cbs_polish_1418_0, arg1);
    } else {
      QMotifStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QMotifStyle::polish(QWidget *)
  void cbs_polish_1315_0(QWidget *arg1)
  {
    QMotifStyle::polish(arg1);
  }

  virtual void polish(QWidget *arg1)
  {
    if (cb_polish_1315_0.can_issue()) {
      cb_polish_1315_0.issue<QMotifStyle_Adaptor, QWidget *>(&QMotifStyle_Adaptor::cbs_polish_1315_0, arg1);
    } else {
      QMotifStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QMotifStyle::polish(QApplication *)
  void cbs_polish_1843_0(QApplication *arg1)
  {
    QMotifStyle::polish(arg1);
  }

  virtual void polish(QApplication *arg1)
  {
    if (cb_polish_1843_0.can_issue()) {
      cb_polish_1843_0.issue<QMotifStyle_Adaptor, QApplication *>(&QMotifStyle_Adaptor::cbs_polish_1843_0, arg1);
    } else {
      QMotifStyle::polish(arg1);
    }
  }

  //  [adaptor impl] QSize QMotifStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)
  QSize cbs_sizeFromContents_c8477_1(const qt_gsi::Converter<QStyle::ContentsType>::target_type & ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    return QMotifStyle::sizeFromContents(qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(ct).cref(), opt, contentsSize, widget);
  }

  virtual QSize sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    if (cb_sizeFromContents_c8477_1.can_issue()) {
      return cb_sizeFromContents_c8477_1.issue<QMotifStyle_Adaptor, QSize, const qt_gsi::Converter<QStyle::ContentsType>::target_type &, const QStyleOption *, const QSize &, const QWidget *>(&QMotifStyle_Adaptor::cbs_sizeFromContents_c8477_1, qt_gsi::CppToQtAdaptor<QStyle::ContentsType>(ct), opt, contentsSize, widget);
    } else {
      return QMotifStyle::sizeFromContents(ct, opt, contentsSize, widget);
    }
  }

  //  [adaptor impl] QPalette QMotifStyle::standardPalette()
  QPalette cbs_standardPalette_c0_0() const
  {
    return QMotifStyle::standardPalette();
  }

  virtual QPalette standardPalette() const
  {
    if (cb_standardPalette_c0_0.can_issue()) {
      return cb_standardPalette_c0_0.issue<QMotifStyle_Adaptor, QPalette>(&QMotifStyle_Adaptor::cbs_standardPalette_c0_0);
    } else {
      return QMotifStyle::standardPalette();
    }
  }

  //  [adaptor impl] QPixmap QMotifStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)
  QPixmap cbs_standardPixmap_c6956_1(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    return QMotifStyle::standardPixmap(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(_standardPixmap).cref(), opt, widget);
  }

  virtual QPixmap standardPixmap(QStyle::StandardPixmap _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardPixmap_c6956_1.can_issue()) {
      return cb_standardPixmap_c6956_1.issue<QMotifStyle_Adaptor, QPixmap, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QMotifStyle_Adaptor::cbs_standardPixmap_c6956_1, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardPixmap), opt, widget);
    } else {
      return QMotifStyle::standardPixmap(_standardPixmap, opt, widget);
    }
  }

  //  [adaptor impl] int QMotifStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)
  int cbs_styleHint_c8615_3(const qt_gsi::Converter<QStyle::StyleHint>::target_type & hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    return QMotifStyle::styleHint(qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(hint).cref(), opt, widget, returnData);
  }

  virtual int styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    if (cb_styleHint_c8615_3.can_issue()) {
      return cb_styleHint_c8615_3.issue<QMotifStyle_Adaptor, int, const qt_gsi::Converter<QStyle::StyleHint>::target_type &, const QStyleOption *, const QWidget *, QStyleHintReturn *>(&QMotifStyle_Adaptor::cbs_styleHint_c8615_3, qt_gsi::CppToQtAdaptor<QStyle::StyleHint>(hint), opt, widget, returnData);
    } else {
      return QMotifStyle::styleHint(hint, opt, widget, returnData);
    }
  }

  //  [adaptor impl] QRect QMotifStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)
  QRect cbs_subControlRect_c9798_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const qt_gsi::Converter<QStyle::SubControl>::target_type & sc, const QWidget *widget) const
  {
    return QMotifStyle::subControlRect(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(sc).cref(), widget);
  }

  virtual QRect subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget) const
  {
    if (cb_subControlRect_c9798_1.can_issue()) {
      return cb_subControlRect_c9798_1.issue<QMotifStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const qt_gsi::Converter<QStyle::SubControl>::target_type &, const QWidget *>(&QMotifStyle_Adaptor::cbs_subControlRect_c9798_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, qt_gsi::CppToQtAdaptor<QStyle::SubControl>(sc), widget);
    } else {
      return QMotifStyle::subControlRect(cc, opt, sc, widget);
    }
  }

  //  [adaptor impl] QRect QMotifStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)
  QRect cbs_subElementRect_c6528_1(const qt_gsi::Converter<QStyle::SubElement>::target_type & r, const QStyleOption *opt, const QWidget *widget) const
  {
    return QMotifStyle::subElementRect(qt_gsi::QtToCppAdaptor<QStyle::SubElement>(r).cref(), opt, widget);
  }

  virtual QRect subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_subElementRect_c6528_1.can_issue()) {
      return cb_subElementRect_c6528_1.issue<QMotifStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::SubElement>::target_type &, const QStyleOption *, const QWidget *>(&QMotifStyle_Adaptor::cbs_subElementRect_c6528_1, qt_gsi::CppToQtAdaptor<QStyle::SubElement>(r), opt, widget);
    } else {
      return QMotifStyle::subElementRect(r, opt, widget);
    }
  }

  //  [adaptor impl] void QMotifStyle::unpolish(QWidget *)
  void cbs_unpolish_1315_0(QWidget *arg1)
  {
    QMotifStyle::unpolish(arg1);
  }

  virtual void unpolish(QWidget *arg1)
  {
    if (cb_unpolish_1315_0.can_issue()) {
      cb_unpolish_1315_0.issue<QMotifStyle_Adaptor, QWidget *>(&QMotifStyle_Adaptor::cbs_unpolish_1315_0, arg1);
    } else {
      QMotifStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QMotifStyle::unpolish(QApplication *)
  void cbs_unpolish_1843_0(QApplication *arg1)
  {
    QMotifStyle::unpolish(arg1);
  }

  virtual void unpolish(QApplication *arg1)
  {
    if (cb_unpolish_1843_0.can_issue()) {
      cb_unpolish_1843_0.issue<QMotifStyle_Adaptor, QApplication *>(&QMotifStyle_Adaptor::cbs_unpolish_1843_0, arg1);
    } else {
      QMotifStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QMotifStyle::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMotifStyle::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMotifStyle_Adaptor, QChildEvent *>(&QMotifStyle_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMotifStyle::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMotifStyle::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMotifStyle::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMotifStyle_Adaptor, QEvent *>(&QMotifStyle_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMotifStyle::customEvent(arg1);
    }
  }

  //  [emitter impl] void QMotifStyle::destroyed(QObject *)
  void emitter_QMotifStyle_destroyed_1302(QObject *arg1)
  {
    emit QMotifStyle::destroyed(arg1);
  }

  //  [adaptor impl] void QMotifStyle::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMotifStyle::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMotifStyle_Adaptor, const char *>(&QMotifStyle_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMotifStyle::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QMotifStyle::eventFilter(QObject *o, QEvent *e)
  bool cbs_eventFilter_2411_0(QObject *o, QEvent *e)
  {
    return QMotifStyle::eventFilter(o, e);
  }

  virtual bool eventFilter(QObject *o, QEvent *e)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMotifStyle_Adaptor, bool, QObject *, QEvent *>(&QMotifStyle_Adaptor::cbs_eventFilter_2411_0, o, e);
    } else {
      return QMotifStyle::eventFilter(o, e);
    }
  }

  //  [adaptor impl] void QMotifStyle::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMotifStyle::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMotifStyle_Adaptor, QTimerEvent *>(&QMotifStyle_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMotifStyle::timerEvent(event);
    }
  }

  gsi::Callback cb_drawComplexControl_c9027_1;
  gsi::Callback cb_drawControl_c8285_1;
  gsi::Callback cb_drawItemPixmap_c5678_0;
  gsi::Callback cb_drawItemText_c10604_1;
  gsi::Callback cb_drawPrimitive_c8501_1;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_generatedIconPixmap_c5776_0;
  gsi::Callback cb_hitTestComplexControl_c9517_1;
  gsi::Callback cb_itemPixmapRect_c4360_0;
  gsi::Callback cb_itemTextRect_c7544_0;
  gsi::Callback cb_pixelMetric_c6642_2;
  gsi::Callback cb_polish_1418_0;
  gsi::Callback cb_polish_1315_0;
  gsi::Callback cb_polish_1843_0;
  gsi::Callback cb_sizeFromContents_c8477_1;
  gsi::Callback cb_standardPalette_c0_0;
  gsi::Callback cb_standardPixmap_c6956_1;
  gsi::Callback cb_styleHint_c8615_3;
  gsi::Callback cb_subControlRect_c9798_1;
  gsi::Callback cb_subElementRect_c6528_1;
  gsi::Callback cb_unpolish_1315_0;
  gsi::Callback cb_unpolish_1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMotifStyle_Adaptor::~QMotifStyle_Adaptor() { }

//  Constructor QMotifStyle::QMotifStyle(bool useHighlightCols) (adaptor class)

static void _init_ctor_QMotifStyle_Adaptor_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("useHighlightCols", true, "false");
  decl->add_arg<bool > (argspec_0);
  decl->set_return_new<QMotifStyle_Adaptor> ();
}

static void _call_ctor_QMotifStyle_Adaptor_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  ret.write<QMotifStyle_Adaptor *> (new QMotifStyle_Adaptor (arg1));
}


// void QMotifStyle::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMotifStyle::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMotifStyle::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QMotifStyle_Adaptor *)cls)->emitter_QMotifStyle_destroyed_1302 (arg1);
}


// void QMotifStyle::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QMotifStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawComplexControl_c9027_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawComplexControl_c9027_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_drawComplexControl_c9027_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawComplexControl_c9027_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_drawComplexControl_c9027_1 = cb;
}


// void QMotifStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawControl_c8285_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawControl_c8285_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_drawControl_c8285_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawControl_c8285_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_drawControl_c8285_1 = cb;
}


// void QMotifStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)

static void _init_cbs_drawItemPixmap_c5678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemPixmap_c5678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPixmap &arg4 = args.read<const QPixmap & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_drawItemPixmap_c5678_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawItemPixmap_c5678_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_drawItemPixmap_c5678_0 = cb;
}


// void QMotifStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)

static void _init_cbs_drawItemText_c10604_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemText_c10604_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  const QPalette &arg4 = args.read<const QPalette & > (heap);
  bool arg5 = args.read<bool > (heap);
  const QString &arg6 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_drawItemText_c10604_1 (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static void _set_callback_cbs_drawItemText_c10604_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_drawItemText_c10604_1 = cb;
}


// void QMotifStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawPrimitive_c8501_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawPrimitive_c8501_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  QPainter *arg3 = args.read<QPainter * > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_drawPrimitive_c8501_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawPrimitive_c8501_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_drawPrimitive_c8501_1 = cb;
}


// bool QMotifStyle::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMotifStyle_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMotifStyle::eventFilter(QObject *o, QEvent *e)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("e");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMotifStyle_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QPixmap QMotifStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)

static void _init_cbs_generatedIconPixmap_c5776_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_generatedIconPixmap_c5776_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > (heap);
  const QPixmap &arg2 = args.read<const QPixmap & > (heap);
  const QStyleOption *arg3 = args.read<const QStyleOption * > (heap);
  ret.write<QPixmap > ((QPixmap)((QMotifStyle_Adaptor *)cls)->cbs_generatedIconPixmap_c5776_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_generatedIconPixmap_c5776_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_generatedIconPixmap_c5776_0 = cb;
}


// QStyle::SubControl QMotifStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)

static void _init_cbs_hitTestComplexControl_c9517_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_cbs_hitTestComplexControl_c9517_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const QPoint &arg3 = args.read<const QPoint & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)((QMotifStyle_Adaptor *)cls)->cbs_hitTestComplexControl_c9517_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_hitTestComplexControl_c9517_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_hitTestComplexControl_c9517_1 = cb;
}


// QRect QMotifStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)

static void _init_cbs_itemPixmapRect_c4360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemPixmapRect_c4360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  int arg2 = args.read<int > (heap);
  const QPixmap &arg3 = args.read<const QPixmap & > (heap);
  ret.write<QRect > ((QRect)((QMotifStyle_Adaptor *)cls)->cbs_itemPixmapRect_c4360_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_itemPixmapRect_c4360_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_itemPixmapRect_c4360_0 = cb;
}


// QRect QMotifStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)

static void _init_cbs_itemTextRect_c7544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemTextRect_c7544_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  int arg3 = args.read<int > (heap);
  bool arg4 = args.read<bool > (heap);
  const QString &arg5 = args.read<const QString & > (heap);
  ret.write<QRect > ((QRect)((QMotifStyle_Adaptor *)cls)->cbs_itemTextRect_c7544_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_itemTextRect_c7544_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_itemTextRect_c7544_0 = cb;
}


// exposed int QMotifStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)

static void _init_fp_layoutSpacingImplementation_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_fp_layoutSpacingImplementation_c11697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  const QStyleOption *arg4 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg5 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<int > ((int)((QMotifStyle_Adaptor *)cls)->fp_QMotifStyle_layoutSpacingImplementation_c11697 (arg1, arg2, arg3, arg4, arg5));
}


// int QMotifStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_pixelMetric_c6642_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_cbs_pixelMetric_c6642_2 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<int > ((int)((QMotifStyle_Adaptor *)cls)->cbs_pixelMetric_c6642_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_pixelMetric_c6642_2 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_pixelMetric_c6642_2 = cb;
}


// void QMotifStyle::polish(QPalette &)

static void _init_cbs_polish_1418_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1418_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPalette &arg1 = args.read<QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_polish_1418_0 (arg1);
}

static void _set_callback_cbs_polish_1418_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_polish_1418_0 = cb;
}


// void QMotifStyle::polish(QWidget *)

static void _init_cbs_polish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_polish_1315_0 (arg1);
}

static void _set_callback_cbs_polish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_polish_1315_0 = cb;
}


// void QMotifStyle::polish(QApplication *)

static void _init_cbs_polish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_polish_1843_0 (arg1);
}

static void _set_callback_cbs_polish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_polish_1843_0 = cb;
}


// exposed int QMotifStyle::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMotifStyle_Adaptor *)cls)->fp_QMotifStyle_receivers_c1731 (arg1));
}


// exposed QObject *QMotifStyle::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMotifStyle_Adaptor *)cls)->fp_QMotifStyle_sender_c0 ());
}


// QSize QMotifStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)

static void _init_cbs_sizeFromContents_c8477_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeFromContents_c8477_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QSize &arg3 = args.read<const QSize & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QSize > ((QSize)((QMotifStyle_Adaptor *)cls)->cbs_sizeFromContents_c8477_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sizeFromContents_c8477_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_sizeFromContents_c8477_1 = cb;
}


// exposed QIcon QMotifStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)

static void _init_fp_standardIconImplementation_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_fp_standardIconImplementation_c6956 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & >() (args, heap);
  const QStyleOption *arg2 = args ? gsi::arg_reader<const QStyleOption * >() (args, heap) : gsi::arg_maker<const QStyleOption * >() (0, heap);
  const QWidget *arg3 = args ? gsi::arg_reader<const QWidget * >() (args, heap) : gsi::arg_maker<const QWidget * >() (0, heap);
  ret.write<QIcon > ((QIcon)((QMotifStyle_Adaptor *)cls)->fp_QMotifStyle_standardIconImplementation_c6956 (arg1, arg2, arg3));
}


// QPalette QMotifStyle::standardPalette()

static void _init_cbs_standardPalette_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_cbs_standardPalette_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)((QMotifStyle_Adaptor *)cls)->cbs_standardPalette_c0_0 ());
}

static void _set_callback_cbs_standardPalette_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_standardPalette_c0_0 = cb;
}


// QPixmap QMotifStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardPixmap_c6956_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_standardPixmap_c6956_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QPixmap > ((QPixmap)((QMotifStyle_Adaptor *)cls)->cbs_standardPixmap_c6956_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardPixmap_c6956_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_standardPixmap_c6956_1 = cb;
}


// int QMotifStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)

static void _init_cbs_styleHint_c8615_3 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_cbs_styleHint_c8615_3 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  QStyleHintReturn *arg4 = args.read<QStyleHintReturn * > (heap);
  ret.write<int > ((int)((QMotifStyle_Adaptor *)cls)->cbs_styleHint_c8615_3 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_styleHint_c8615_3 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_styleHint_c8615_3 = cb;
}


// QRect QMotifStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)

static void _init_cbs_subControlRect_c9798_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_cbs_subControlRect_c9798_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (heap);
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > (heap);
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (heap);
  const QWidget *arg4 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QMotifStyle_Adaptor *)cls)->cbs_subControlRect_c9798_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_subControlRect_c9798_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_subControlRect_c9798_1 = cb;
}


// QRect QMotifStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_subElementRect_c6528_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_subElementRect_c6528_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (heap);
  const QStyleOption *arg2 = args.read<const QStyleOption * > (heap);
  const QWidget *arg3 = args.read<const QWidget * > (heap);
  ret.write<QRect > ((QRect)((QMotifStyle_Adaptor *)cls)->cbs_subElementRect_c6528_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_subElementRect_c6528_1 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_subElementRect_c6528_1 = cb;
}


// void QMotifStyle::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QMotifStyle::unpolish(QWidget *)

static void _init_cbs_unpolish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_unpolish_1315_0 (arg1);
}

static void _set_callback_cbs_unpolish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_unpolish_1315_0 = cb;
}


// void QMotifStyle::unpolish(QApplication *)

static void _init_cbs_unpolish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QApplication *arg1 = args.read<QApplication * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMotifStyle_Adaptor *)cls)->cbs_unpolish_1843_0 (arg1);
}

static void _set_callback_cbs_unpolish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMotifStyle_Adaptor *)cls)->cb_unpolish_1843_0 = cb;
}


namespace gsi
{

gsi::Class<QMotifStyle> &qtdecl_QMotifStyle ();

static gsi::Methods methods_QMotifStyle_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMotifStyle::QMotifStyle(bool useHighlightCols)\nThis method creates an object of class QMotifStyle.", &_init_ctor_QMotifStyle_Adaptor_864, &_call_ctor_QMotifStyle_Adaptor_864);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMotifStyle::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMotifStyle::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMotifStyle::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMotifStyle::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@brief Virtual method void QMotifStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawComplexControl", "@hide", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1, &_set_callback_cbs_drawComplexControl_c9027_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@brief Virtual method void QMotifStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawControl", "@hide", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1, &_set_callback_cbs_drawControl_c8285_1);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Virtual method void QMotifStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemPixmap", "@hide", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0, &_set_callback_cbs_drawItemPixmap_c5678_0);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@brief Virtual method void QMotifStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawItemText", "@hide", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1, &_set_callback_cbs_drawItemText_c10604_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@brief Virtual method void QMotifStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("drawPrimitive", "@hide", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1, &_set_callback_cbs_drawPrimitive_c8501_1);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMotifStyle::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMotifStyle::eventFilter(QObject *o, QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Virtual method QPixmap QMotifStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("generatedIconPixmap", "@hide", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0, &_set_callback_cbs_generatedIconPixmap_c5776_0);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Virtual method QStyle::SubControl QMotifStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("hitTestComplexControl", "@hide", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1, &_set_callback_cbs_hitTestComplexControl_c9517_1);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Virtual method QRect QMotifStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemPixmapRect", "@hide", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0, &_set_callback_cbs_itemPixmapRect_c4360_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@brief Virtual method QRect QMotifStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("itemTextRect", "@hide", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0, &_set_callback_cbs_itemTextRect_c7544_0);
  methods += new qt_gsi::GenericMethod ("*layoutSpacingImplementation", "@brief Method int QMotifStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_layoutSpacingImplementation_c11697, &_call_fp_layoutSpacingImplementation_c11697);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@brief Virtual method int QMotifStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("pixelMetric", "@hide", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2, &_set_callback_cbs_pixelMetric_c6642_2);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QMotifStyle::polish(QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0, &_set_callback_cbs_polish_1418_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QMotifStyle::polish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0, &_set_callback_cbs_polish_1315_0);
  methods += new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QMotifStyle::polish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0, &_set_callback_cbs_polish_1843_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMotifStyle::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMotifStyle::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@brief Virtual method QSize QMotifStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("sizeFromContents", "@hide", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1, &_set_callback_cbs_sizeFromContents_c8477_1);
  methods += new qt_gsi::GenericMethod ("*standardIconImplementation", "@brief Method QIcon QMotifStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_standardIconImplementation_c6956, &_call_fp_standardIconImplementation_c6956);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@brief Virtual method QPalette QMotifStyle::standardPalette()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPalette", "@hide", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0, &_set_callback_cbs_standardPalette_c0_0);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@brief Virtual method QPixmap QMotifStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPixmap_c6956_1, &_call_cbs_standardPixmap_c6956_1);
  methods += new qt_gsi::GenericMethod ("standardPixmap", "@hide", true, &_init_cbs_standardPixmap_c6956_1, &_call_cbs_standardPixmap_c6956_1, &_set_callback_cbs_standardPixmap_c6956_1);
  methods += new qt_gsi::GenericMethod ("styleHint", "@brief Virtual method int QMotifStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("styleHint", "@hide", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3, &_set_callback_cbs_styleHint_c8615_3);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@brief Virtual method QRect QMotifStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subControlRect", "@hide", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1, &_set_callback_cbs_subControlRect_c9798_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@brief Virtual method QRect QMotifStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("subElementRect", "@hide", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1, &_set_callback_cbs_subElementRect_c6528_1);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMotifStyle::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QMotifStyle::unpolish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0, &_set_callback_cbs_unpolish_1315_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QMotifStyle::unpolish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0);
  methods += new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0, &_set_callback_cbs_unpolish_1843_0);
  return methods;
}

gsi::Class<QMotifStyle_Adaptor> decl_QMotifStyle_Adaptor (qtdecl_QMotifStyle (), "QtGui", "QMotifStyle",
  methods_QMotifStyle_Adaptor (),
  "@qt\n@brief Binding of QMotifStyle");

}

