/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __FILELISTVIEW_H
#define __FILELISTVIEW_H

#include <klistview.h>
#include <qvaluevector.h>

class SweepFileInfo;
class FileViewItem;
class KPopupMenu;
class QPixmap;

enum Column
{
	FileName = 2<<0,
	FileDir =  2<<1,
	Target  =  2<<2,
	Size    =  2<<3,
	Owner   =  2<<4,
	Group   =  2<<5,
	ModTime =  2<<6,
	Permissions = 2<<7,
	AccessTime = 2<<8,
	Score = 2<<9,
};

class FileListView: public KListView
{
        Q_OBJECT

	private:
		FileListView *nextview;
		FileListView *prevview;
		KPopupMenu *menu;
		QPixmap *diricon;
		int cols; //!<column flags
		QValueVector<Column> coltypes;

	signals:
		void openDirectory(const QString &path);
		void selectionChanged(int n, unsigned int size);
		
	protected slots:
		virtual void openDirSelected();
		virtual void showContextMenu(QListViewItem *item, const QPoint &point, int col);

	public slots:
		virtual void setAll(bool state);
		virtual void selectAll();
		virtual void selectNone();
        public:
                FileListView(QWidget *parent, FileListView *prev=NULL);
                virtual ~FileListView();

		virtual void setupColumns(int cols = 0xffff);
		virtual void stateChanged(SweepFileInfo *f, bool state);
		virtual FileViewItem* find(SweepFileInfo *f);
		virtual KPopupMenu* contextMenu() const;
		bool hasColumn(int c) const { return cols & c; }
		int getColumns() const { return cols; }
		int getColumnType(int c) const { return coltypes[c]; }
};

#endif
