/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __KLEANSWEEPCFG_H
#define __KLEANSWEEPCFG_H

/*! \file kleansweepcfg.h */

#include <kconfigskeleton.h>
#include "enummap.h"
#include "kleansweep.h"

class KleanSweepConfig: public KConfigSkeleton
{
	protected:
		QStringList glob_excludepth;
		QStringList orphans_excludepath;
		QStringList orphans_includepath;
		bool progress;
		bool optsearch;
		bool score;
		QString orphans_distrotype;
		//int oldfiles;
		static const Utility::EnumMap<DistroPkg> pkgtype2string[];

		KleanSweepConfig();
		~KleanSweepConfig();

		DistroPkg discoverDistroPkg();

	public:
		static KleanSweepConfig& instance();

		QStringList globalExcludePaths() const;
		void globalExcludePaths(const QStringList &list);
		QStringList orphansExcludePaths() const;
		void orphansExcludePaths(const QStringList &list);
		QStringList orphansIncludePaths() const;
		void orphansIncludePaths(const QStringList &list);
		bool showProgress() const;
		bool showScore() const;
		DistroPkg distroPackageManager() const;
		void showProgress(bool f);
		void showScore(bool f);
		bool optimizeSearches() const;
		void optimizeSearches(bool f);
		void distroPackageManager(DistroPkg p);
		//int oldFilesAge() const;
		//void oldFilesAge(int d);

};

#endif

