/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __SWEEPWIZARD_H
#define __SWEEPWIZARD_H

#include <kwizard.h>
#include "sweepscanner.h"
#include "filelistview.h"

class QCheckBox;
class QLineEdit;
class QBoxLayout;
class QPixmap;
class KPushButton;
class KURLRequester;
class KTabWidget;
class SweepFileInfo;
class LogWidget;
class SummaryLabel;
class ScanProgressDialog;

class SweeperWizard: public KWizard
{
        Q_OBJECT
        
        protected:
		bool shown_startup_warning;
                QWidget *resultspage;
		QWidget *welcomepage;
		QWidget *archivepage;
		QWidget *startpage;
		QWidget *removepage;
		KTabWidget *resultstabs;
                SweepScanner *scanner;
		QCheckBox *cb_scan[12];
                FileListView *views[12];
		FileListView *remview;
		FileListView *lastview;
		LogWidget *logwidget;
		QCheckBox *cb_writable;
		QCheckBox *cb_createarch;
		KURLRequester *url_startpath;
		QPixmap *kleansweep_bar1;
		KPushButton *b_selectall;
		KPushButton *b_clearall;
		KPushButton *b_saveresrep;
		KPushButton *b_stop;
		SummaryLabel *summary;
		ScanProgressDialog *progress;

		int numchoosen;

		struct ScanOpts
		{
			SweepScanner::FileType ftype;
			QString optname;
			int columns;
			QString info;
		};
		static ScanOpts scanopts[];
		static int CommonColumns;
                
        protected slots:
                void addFileEntry(SweepScanner::FileType t, SweepFileInfo *f);
                void addFileEntry(SweepScanner::FileType t, SweepFileInfo *f, SweepFileInfo *parent);
		void scannerFinished(bool status);
		void scanCategoryToggled(bool f);
		void openDirectory(const QString &path);
		void selectAllClicked();
		void clearAllClicked();
		void stopClicked();
		void showConfigDialog();
		void showAbout();
		void saveReport();
                
        protected:
                void setupWelcomePage();
                void setupStartPage();
                void setupResultsPage();
		void setupArchivePage();
		void setupRemovePage();
		void addLeftSidePic(QWidget *page, QBoxLayout *parent);
		void moveEvent(QMoveEvent *e);
		void resizeEvent(QResizeEvent *e);

        public:
                SweeperWizard(QWidget *parent);
                virtual ~SweeperWizard();
                virtual void showPage(QWidget *w);
		virtual void show();
};

#endif
