#include "CKlearAppTXTDecoder.h"

CKlearAppTXTDecoder::CKlearAppTXTDecoder( CKlearAppConfig *config, QObject *const parent ) : QObject()
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::CKlearAppTXTDecoder( CKlearAppConfig *config )";

  this->KlearConfig = config;
  this->secound = ' ';
  this->row = 0;
  this->doubleHeight = 0;
  this->number="";
  this->pageNumber="";


  headerMutex.lock();
  //std::cout << "h lock txtdec" << std::endl;
    for ( int i = 0; i < 24; i++ )
      this->TXTHeaderData[ i ] = 20;
  headerMutex.unlock();
  //std::cout << "h unlock" << std::endl;
  bodyMutex.lock();
  //std::cout << "b lock txtdec" << std::endl;
    for ( int i = 0; i < 24; i++ )
      for ( int j = 0; j < 40; j++ )
        this->TXTBodyData[ i ][ j ] = 20;
  bodyMutex.unlock();
  //std::cout << "b unlock txtdec" << std::endl;

}

CKlearAppTXTDecoder::~CKlearAppTXTDecoder()
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::~CKlearAppTXTDecoder()";

  delete this->KlearConfig;
  delete this->pageNumber;
}

int CKlearAppTXTDecoder::decodeSectionPAT( u_char *buf )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodeSectionPAT( u_char *buf )";

  typedef struct _PAT
  {
    u_int section_length;
  } PAT;

  typedef struct _PAT_LIST
  {
    u_int program_number;
    u_int network_pmt_PID;
  } PAT_LIST;

  PAT pat;
  PAT_LIST patList;
  int n;

  pat.section_length = getBits( buf, 0, 12, 12 );
  n = pat.section_length - 9;
  buf = buf + 8;

  for( ; n >= 4; n = n - 4 )
  {
    patList.program_number = getBits( buf, 0, 0, 16 );
    patList.network_pmt_PID = getBits( buf, 0, 19, 13 );
    buf += 4;

    if( patList.program_number == this->KlearConfig->getServiceID() )
    {
      std::cout << "PMT: " << patList.network_pmt_PID << std::endl;
      return patList.network_pmt_PID;
    }
  }
}

int CKlearAppTXTDecoder::decodeSectionPMT( u_char *buf )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodeSectionPMT( u_char *buf )";

  typedef struct _PMT
  {
    int section_length;
    int program_info_length;
  } PMT;

  typedef struct _PMT_LIST
  {
    u_int stream_type;
    u_int elementary_PID;
    int ES_info_length;
  } PMT_LIST;

  PMT pmt;
  PMT_LIST pmtList;
  int len1;
  int len2;

  pmt.section_length = getBits( buf, 0, 12, 12 );
  pmt.program_info_length = getBits( buf, 0, 84, 12 );

  len1 = pmt.section_length - 9;
  buf += 9 + 3;
  len2 = pmt.program_info_length;

  while( len1 > 4 )
  {
    pmtList.stream_type = getBits( buf, 0,  0, 8 );
    pmtList.elementary_PID = getBits( buf, 0, 11, 13 );
    pmtList.ES_info_length = getBits( buf, 0, 28, 12 );

    if( pmtList.stream_type == 6 )
    {
      std::cout << "TXT: " << pmtList.elementary_PID << std::endl;
      return pmtList.elementary_PID;
    }

    buf += 5;
    len1 -= 5;
    len2 = pmtList.ES_info_length;

    while( len2 > 0 )
    {
      int x;
      x = descriptor( buf );
      len2 -= x;
      len1 -= x;
      buf += x;
    }
  }
}

void CKlearAppTXTDecoder::decodePESTXT( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodePESTXT( u_char *buf )";

  buf += 6;
  len -= 6;

  typedef struct _PES_Packet{
    u_int PTS_DTS_flags;
    u_int PES_header_data_length;
  }PES_Packet;

  PES_Packet p;
  u_char *buf_start = buf;

  p.PTS_DTS_flags          = getBits( buf, 0,  8, 2 );
  p.PES_header_data_length = getBits( buf, 0, 16, 8 );

  buf += 3;

  if( p.PTS_DTS_flags & 0x02 )
    buf += 5;

  {
    int len2 = p.PES_header_data_length + 3 - ( buf - buf_start );

    if ( len2 > 0 )
      buf += len2;
  }

  {
    int len2 = len - ( buf - buf_start );
    decodePrivateData( buf, len2 );
  }
}

void CKlearAppTXTDecoder::decodePrivateData( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodePrivateData( u_char *buf, int len )";

  u_int data_identifier;
  data_identifier = getBits( buf , 0,  0,  8 );

  if( data_identifier >= 0x10 && data_identifier <= 0x1F )
    decodeEBUData( buf, len );
}


void CKlearAppTXTDecoder::decodeEBUData(u_char *buf, int len)
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodeEBUData( u_char *buf, int len )";

  buf++;
  len--;

  while( len > 0 ) {
    int len2;
    int dataUnitID;
    int n = 0;

    dataUnitID = getBits ( buf, 0,  0,  8 );
    len2       = getBits ( buf, 0,  8,  8 );

    buf += 2;
    len -= 2;

    if ( dataUnitID == 0x02 || dataUnitID == 0x03 || dataUnitID == 0xC0 || dataUnitID == 0xC1)
      n = decodeTXTDataField( buf, len2 );

    buf += len2;
    len -= len2;
  }
}

int CKlearAppTXTDecoder::decodeTXTDataField( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodeTXTDataField( u_char *buf, int len )";

  int len2;

  buf += 2;
  len -= 2;

  for ( int i = 0; i < 42; i++ )
    *( buf + i ) = invtab[ *( buf + i ) ];

  len2 = decodeTXTPacketData( buf, 42 );

  buf += len2;
  len -= len2;

  return 44;
}

int CKlearAppTXTDecoder::decodeTXTPacketData( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::decodeTXTPacketData( u_char *buf, int len )";

  std::cout << "start decode" << std::endl;

  int  x;
  int  packet_nr = -1;
  int  mag_nr = -1;
  int  page_nr = -1;
  int  sub_page_nr = -1;

  x = unhamW84( *buf, *( buf + 1 ) );
  packet_nr =  ( x >> 3 ) & 0x1F;
  mag_nr = x & 7;
  if ( ! mag_nr ) mag_nr = 8;

  page_nr     = ( unhamB84( *( buf + 2 ) ) & 0xF) | ( ( unhamB84( *( buf + 3 ) ) & 0xF ) << 4 );
  sub_page_nr = ( unhamW84( *( buf + 4 ), *( buf + 5 ) ) | ( unhamW84( *( buf + 6 ), *( buf + 7 ) ) << 8 ) ) & 0x3F7F;

  if( packet_nr == 0 )
  {
    if( this->pageNumber == number )
    {
      emit changedBodyInfo();
    }

    unParityTeletextData( buf + 10, len - 10 );
    //printhexline_buf( buf + 10 , len - 10 );
    setTXTHeaderData( buf + 10, len - 10 );
    searchPage( buf + 10, len - 10 );
  }

  if( packet_nr == 1 && this->pageNumber == number )
  {
    std::cout << "Seite " << this->number << " gefunden!" << std::endl;
    this->row = 0;
    //std::cout << "for lock" << std::endl;
    bodyMutex.lock();
    //std::cout << "b lock dpd" << std::endl;
    for ( int i = 0; i < 24; i++ )
      for ( int j = 0; j < 40; j++ )
        this->TXTBodyData[ i ][ j ] = 20;
    bodyMutex.unlock();
    //std::cout << "b unlock" << std::endl;
    unParityTeletextData( buf + 2, len - 2 );
    //printhexline_buf( buf + 2 , len - 2 );
    setTXTBodyData( buf + 2, len - 2 );
    std::cout << "end decode" << std::endl;
    return len;
  }

  if( packet_nr >= 2 && packet_nr <= 24 && this->pageNumber == number )
  {
    unParityTeletextData( buf + 2, len - 2 );
    //printhexline_buf( buf + 2 , len - 2 );
    setTXTBodyData( buf + 2, len - 2 );

    std::cout << "end decode" << std::endl;
    return len;
  }

  if( packet_nr > 24 )
  {

    std::cout << "end decode" << std::endl;
    return len;
  }

  /*{
    char *s = "";
    int  x = ( mag_nr << 8 | page_nr );

    if ( x == 0x1BE ) s = "Automatic Channel Installation (ACI)";
    if ( x == 0x1F0 ) s = "Basic TOP Table (BTT)";
    if ( page_nr == 0xFD ) s = "Magazine Inventory Page (MIP)";
    if ( page_nr == 0xFE ) s = "Magazine Organization Table (MOT)";
    if ( page_nr == 0xFF ) s = "Time filling and terminator";
    if ( page_nr == 0xFF && sub_page_nr == 0x3F7F ) s = "Null packet";
  }

  if ( page_nr == 0xFF && sub_page_nr == 0x3F7F ) return 8;

  {
    u_char x;
    int c4, c5, c6, c7, c8, c9, c10, c11;

    c4 = *( buf + 5 ) & 0x80; // bit 8
    x  = *( buf + 7 );
    c5 = x & 0x20; // bit 6
    c6 = x & 0x80; // bit 7

    x   = *( buf + 8 );
    c7  = x & 0x02; // bit 2
    c8  = x & 0x08; // bit 4
    c9  = x & 0x20; // bit 6
    c10 = x & 0x80; // bit 8
    c11  = *( buf + 9 ) & 0x02; // bit 2

   if( c4 | c5 | c6 | c7 | c8 | c9 | c10 | c11 )
    {
      out ( "Control bits: " );
      std::cout << std::endl;

      if( c4 )
      {
        out( "C4 = Erase page" );
        std::cout << std::endl;
      }

      if( c5 )
      {
        out( "C5 = Newsflash" );
        std::cout << std::endl;
      }

      if( c6 )
      {
        out( "C6 = Subtitle" );
        std::cout << std::endl;
      }

      if( c7 )
      {
        out( "C7 = Suppress header" );
        std::cout << std::endl;
      }

      if( c8 )
      {
        out( "C8 = Update indicator" );
        std::cout << std::endl;
      }

      if( c9 )
      {
        out( "C9 = Interrupted sequence" );
        std::cout << std::endl;
      }

      if( c10 )
      {
        out( "C10 = Inhibit display" );
        std::cout << std::endl;
      }

      if( c11 )
      {
        out( "C11 = Magazine serial" );
        std::cout << std::endl;
      }
    }
  }*/

  // -- country/language code  (c12,c13,c14)
  {
    int lang;
    lang = ( unhamB84( *( buf + 9 ) ) >> 1 ) & 7; // unhammed bits 4,6,
  }

  return len;
}

void CKlearAppTXTDecoder::unParityTeletextData( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::unParityTeletextData( u_char *buf, int len )";

  for ( int i = 0; i < len; i++ )
    *( buf + i ) = *( buf + i ) & 0x7F;
}

void CKlearAppTXTDecoder::searchPage( u_char *buf, int len )
{

  const QString __FUNC__ = "CKlearAppTXTDecoder::searchPage( u_char *buf, int len )";

  this->number = "";
  for ( int i = 0; i < 3; i++ )
    this->number += buf[ i ];
}

void CKlearAppTXTDecoder::setTXTHeaderData( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::setTXTHeaderData( u_char *buf, int len )";

  headerMutex.lock();
  //std::cout << "h lock shd" << std::endl;
  for ( int column = 0; column < 32; column++ )
      this->TXTHeaderData[ column ] = ( int )buf[ column ];

  headerMutex.unlock();
  //std::cout << "h unlock" << std::endl;
  if ( this->secound != buf[ 31 ] )
  {
    this->secound = buf[ 31 ];
    emit changedHeaderInfo();
  }
}

void CKlearAppTXTDecoder::setTXTBodyData( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::setTXTBodyData( u_char *buf, len )";
  if ( 0 != strcmp( (const char*)buf, "" ) )  //Hack for packets that are not compliant to the standard.
  {
    bodyMutex.lock();
    //std::cout << "b lock sbd" << std::endl;
    for ( int column = 0; column < 40; column++ )
      this->TXTBodyData[ this->row ][ column ] = ( int )buf[ column ];
    this->row++;
    bodyMutex.unlock();
    //std::cout << "b unlock" << std::endl;
  }

}

void CKlearAppTXTDecoder::printasciiline_buf( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::printasciiline_buf( u_char *buf, int len )";

  u_char c;

  for ( int i = 0; i < len; i++ )
  {
    c = buf[ i ];
    out ( "%c", isprint( ( int ) c ) ? c : '.' );
  }
}

void CKlearAppTXTDecoder::printhexline_buf( u_char *buf, int len )
{
  const QString __FUNC__ = "CKlearAppTXTDecoder::printhexline_buf( u_char *buf, int len )";

  for( int i = 0; i < len; i++ )
   out( "%02x ", ( ( int ) buf[ i ] ) );
  std::cout << std::endl;
}
