/**
\author Omar El-Dakhloul <omar@klear.org>
\file CKlearControllerTXTMain.h
\brief The TXT window controller
*/

#ifndef CKLEARCONTROLLERTXTMAIN_H
#define CKLEARCONTROLLERTXTMAIN_H

#include <qpainter.h>

#include "../../App/TXT/CKlearAppTXTStreamer.h"
#include "../../App/TXT/CKlearAppTXTDecoder.h"
#include "../../App/CKlearAppConfig.h"
#include "../View/CKlearUITXTMain.h"


/**
\class CKlearControllerTXTMain
\author Omar El-Dakhloul <omar@klear.org>
\brief The GUI-controller for the TXT. Controlls the user interaction with the GUI.
*/
class CKlearControllerTXTMain : public CKlearUITXTMain
{
  Q_OBJECT

  public:
    CKlearControllerTXTMain( CKlearAppConfig *config, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~CKlearControllerTXTMain();

  public slots:
    void slotGrabSavedHeader();
    void slotGrabSavedBody();

  signals:
    void changedHeaderInfo();
    void changedBodyInfo();
    void changedPageNumber();

  private:
    int position;
    int row;
    int digit;
    int counter;
    int doubleHeight;
    int binary[ 7 ];
    bool isHoldMosaic;
    int holdMosaic;
    QString pageNumber;
    QString number[ 3 ];

    QMutex asciMutex;
        QString asci;

    QString element;

    QColor backgroundColor;
    QColor charakterColor;
    QColor mosaicColor;
    QFont TXTFont;

    float rectHeight;
    float rectWidth;

    void paintEvent ( QPaintEvent * );

    QString getPageNumber();
    void paintTXTHeader();
    void paintTXTBody( );
    void createWindow();
    void searchPage();
    void keyPressEvent( QKeyEvent *ke );
    void setTXTPageNumber( QString num );
    void closeEvent( QCloseEvent *ce );

    void setLatinNationalOption( int nationalOption );
    void setCharakterColor( int hex );
    void setMosaicColor( int hex );
    void setBackgroundColor( int hex );
    void setDoubleHeight( int size );
    void setDefaultProperties();
    void drawChar( int column );
    void drawMosaic( int column );
    QColor getBackgroundColor();
    QColor getCharakterColor();
    QColor getMosaicColor();
    QFont getTXTFont();
    void paintTXTPageNumber();

    void setBinary( int dezimal );

    CKlearAppConfig *KlearConfig;
    CKlearAppTXTStreamer *TXTStreamer;
    CKlearAppTXTDecoder *TXTDecoder;

    float getRectHeight();
    float getRectWidth();
};

#endif
