/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BINHEADER_H
#define BINHEADER_H

#include <qmap.h>
#include <header.h>

/**
@author Alessandro Bonometti
*/


typedef QMap<int, ServerNumMap> PartNumMap; //Hold <part, <serverid, articlenum>>
typedef QMap <int, int> ServerPartMap; //Holds <serverid, number-of-parts-on-server>
typedef QMap <int, QString> PartMid;

class BinHeader {
	friend class BHListViewItem;
	friend class QMgr;
	friend class QPostItem;
	friend class QUpdItem;
	friend class klibido;
#ifndef NDEBUG
	friend class NewsGroup;
#endif

			
	private:
		QString subj;
		QString from;
		QString date;
		uint numParts;
		uint missingParts;
		uint status;
		uint lines;
		uint size;
		PartNumMap partNum;
		PartMid partMid; //part#, mid (sic!)
		ServerPartMap serverPart; //Useful for speeding loading of headers...
		QMap<uint,uint> partSize; //part#, part Size
		QMap<int, int> serverLowest; 

		ServerNumMap::iterator snmit;
		ServerPartMap::iterator spmit;
		uchar* insert(QString, uchar*);
    	uchar* retrieve(uchar*,QString&);
		PartNumMap::iterator pnmit;
		
	public:
		enum status {bh_downloaded, bh_new, bh_read, bh_queued};
		
		enum Expire_Code {Delete_Read, Delete_Unread, No_Delete, No_Change };
		enum Add_Code { Duplicate_Part, New_Part, Unread_Status };
		void setSubj(QString s) {subj=s;};
		void setFrom(QString s) {from=s;};
		void setDate(QString s) {date=s;};
		void setStatus(uint s) {status=s;};
		void setNumParts(int i) {numParts=missingParts=i;};
		bool addPart(int, Header*);
		bool addPart(int, Header*, NntpHost *);
		void addNzbPart(int, int, QString);
		void addHost(int part, int hostId);
		Add_Code addPart(int, Header*, int);
		
		bool isCompleted();
		QString getSubj() {return subj;};
		QString getFrom() {return from;};
		QString getDate() {return date;};
		inline int getSize() {return size;};
		inline int getLines() {return lines;};
		inline int getParts() {return numParts;};
		inline int getMissingParts() {return missingParts;};
		inline int getStatus () {return status;};
		inline void setStatus(int s) {status=s;};
		BinHeader();
		BinHeader(uchar*, int version=HEADERDB_VERSION);
// 		~BinHeader();
		uchar *data();
		uint getRecordSize();
#ifndef NDEBUG
		void printServerPart(); //Debug function
#endif
		Expire_Code expire(int hostId, int lw);
#if INDEXDB_VERSION != 0
		Expire_Code expirePart(int hostId, int partId);
#endif
		
		
	
};



#endif
