/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "prefview.h"
#include <qradiobutton.h>
#include <qcheckbox.h>
#include "globals.h"

PrefView::PrefView(QWidget* parent, const char* name, WFlags fl)
: prefViewLayout(parent,name,fl)
{
	dViewed=Config().dViewed;
	
	
	singleViewTab=Config().singleViewTab;
	if (singleViewTab) {
		oneTabBtn->setChecked(true);
		askBtn->setEnabled(false);
		
	} else multiTabBtn->setChecked(true);
	
	if (dViewed == Configuration::Ask) {
		if (!singleViewTab)
			askBtn->setChecked(true);
		else keepBtn->setChecked(true);
	} else if (dViewed == Configuration::No)
		keepBtn->setChecked(true);
	else deleteBtn->setChecked(true);
	
	connect(oneTabBtn, SIGNAL(toggled(bool)), this, SLOT(slotSingleTabBtnToggled(bool )));
	
	activateTab=Config().activateTab;
	
	activateBtn->setChecked(activateTab);
	
}

PrefView::~PrefView()
{
}

void PrefView::slotSingleTabBtnToggled( bool on)
{
	if (on) {
		askBtn->setEnabled(false);
		keepBtn->setChecked(true);
	} else askBtn->setEnabled(true);
	
}

/*$SPECIALIZATION$*/


#include "prefview.moc"

